# compute cvar of discrete and some continuous distributions

using Distributions, SpecialFunctions
import Statistics.quantile
include("goldrat_search.jl");


# correct cvar computation with atom splitting
function cvar(ps, xs, θ)
    @assert 0 ≤ θ ≤ 1
    @assert abs(sum(ps) - 1) < 1e-4  "sum is $(sum(ps))"
    @assert all(ps .≥ 0)
    @assert issorted(xs)
    Fs = cumsum(ps);
    Fs[end] = 1;
    i = findfirst(Fs .≥ θ);
    # split atom at i to make quantile exactly θ
    ((Fs[i] - θ)*xs[i] + ps[i+1:end] ⋅ xs[i+1:end])/(1-θ)
end








# some analytic cvars
function cvar(p::Normal, θ)
    μ, σ = params(p);
    μ + σ*(exp(-erfcinv(2θ)^2))/(sqrt(2*π)*(1-θ))
end

function cvar(p::GeneralizedExtremeValue, θ)
    @assert 0 < θ < 1;
    μ, σ, ξ = params(p);
    gi = gamma_inc(1-ξ, -log(θ), 0)[1]
    μ - σ/ξ * (1 - gamma(1-ξ)*gi/(1-θ))
end

function cvar(p::GeneralizedPareto, θ)
    @assert 0 < θ < 1;
    μ, ξ, σ = params(p)
    @assert ξ < 1;
    μ + σ*(ξ-1+(1-θ)^-ξ)/(ξ*(1-ξ))
end

function cvar(p::Bernoulli, θ)
    @assert 0 < θ < 1;
    μ, = params(p);
    if θ <= 1-μ
        μ/(1-θ)
    else
        1
    end
end

# we call 'tailex' the integral \int_z^\infty (x-z)₊ pdf(x) \dif x

function tailex(p::Normal, z)
    μ, σ = params(p);
    q = (z-μ)/(sqrt(2)*σ);
    (μ-z) * erfc(q)/2 + σ*exp(-q^2)/sqrt(2*π)
end

function tailex(p::GeneralizedExtremeValue, z)
    μ, σ, ξ = params(p);
    g1x = gamma(1-ξ);

    if σ ≤ ξ*(μ-z)
        if ξ > 0
            μ-z - σ/ξ*(1-g1x)
        else
            0
        end
    else
        v = (1-(μ-z)*ξ/σ)^(-1/ξ)
        evm1 = -expm1(-v);
        gi = g1x*gamma_inc(1-ξ, v, 0)[2]
        (μ-z)*evm1 - σ/ξ*(evm1+gi-g1x)
    end
end


function tailex(p::GeneralizedPareto, z)
    μ, ξ, σ = params(p)

    if z < μ
        -(z-μ)+σ/(1-ξ)
    else
        (σ^(1/ξ)*((z-μ)*ξ+σ)^(1-1/ξ))/(1-ξ)
    end
end

function tailex(p::MixtureModel, z)
    p.prior.p ⋅ tailex.(p.components, z)
end

function optz(p, θ)
    ϕsect(z -> z + 1/(1-θ)*(tailex(p,z)),
          -100, 100)
end

function cvar(p::MixtureModel, θ)
    @assert 0 < θ < 1;
    optz(p, θ)[1]
end

# funny, the method provided by Distributions.jl does not work
function quantile(p::MixtureModel, θ)
    @assert 0 < θ < 1;
    optz(p, θ)[2]
end


function Ex²(p)
    var(p) + mean(p).^2
end

function Ex²(ps, xs)
    ps ⋅ xs.^2
end
