# run a synthetic experiment
#

using JLD2;
using Distributed;

@everywhere include("runit.jl")


# setup bandit problem

B = 4.5;  # moment constraint
θ = 0.6;  # quantile for CVaR
ϵ = 0.7; 

dist1=MixtureModel([GeneralizedExtremeValue(-1, 1/2,  .4),
                      GeneralizedExtremeValue(-3, 1/2, -.4)]);
dist2=GeneralizedPareto(0, 0.2, 0.55);
dist3=GeneralizedExtremeValue(-1/2, 2/2, 1/10);
# dist4=GeneralizedPareto(0, 0.5, 0.4);

# Dist characteristics:
# dist1 : (1.7th)-moment 4.0148, c_0.6(arm1) -0.1428
# dist2 : (1.7th)-moment 2.36096, c_0.6(arm2) 0.97395
# dist3 : (1.7th)-moment 1.6868, c_0.6(arm2) 1.5474
# dist4 : (1.7th)-moment 1.9769, c_0.6(arm2) 1.75562

global MAB = (dist1, dist2, dist3);

δs = (0.1,0.01,0.001,0.0001);
βs = GK16.(δs);

if length(ARGS) > 1
    filepath = ARGS[1];
    N = parse.(Int64, ARGS[2])
    myrange = 1:N
else
    filepath = "output/";
    N=1000;
    myrange = 1:N;
end

seed = 1932; # repeatability

# compute in parallel
@time data = pmap(i -> runit(seed+i, MAB, βs, B, θ, ϵ), myrange);

# save
@save string(filepath,"experiment.dat") B θ ϵ MAB δs βs myrange seed data