# run a synthetic experiment
#

using JLD2;
using Distributed;

@everywhere include("runit.jl")


# setup bandit problem

θ = 0.6; # quantile for CVaR
ϵ = 1.1; 


dist1=MixtureModel([GeneralizedExtremeValue(-1, 1/2,  .4),
                      GeneralizedExtremeValue(-3, 1/2, -.4)]);
dist2=GeneralizedPareto(2.25,0.1,0.01);


# Arm characteristics:
# dist1 : (1.7th)-moment 4.0148, c_0.6(arm1) -0.1428
# dist2 : (1.7th)-moment 4.28169, c_0.6(dist3) 2.44399

global MAB = (dist1, dist2);

δs = (0.05,);
βs = GK16.(δs);

Bs = 7.5:0.5:25

if length(ARGS) > 0
    filepath = ARGS[1];
    N = parse.(Int64, ARGS[2])
    myrange = 1:N
else
    filepath = "output/";
    N=1000; myrange = 1:N;
end

global seed = 1932; # repeatability

for B in Bs  
    @time data = pmap(i -> runit(seed+i, MAB, βs, B, θ, ϵ), 1:N);

    # save
    @save string(filepath,"1_1varBexperiment",B,".dat") B θ ϵ MAB δs βs myrange seed data
    
    global seed += N
end