using Test;

include("libs/tidnabbil/binary_search.jl")
include("cvar.jl");

# kolmogorov (or sup-norm on the CDF level) projection
# of (xs, ηs) onto distributions with 1+ϵ moment ≤ B.

function kolm_proj(ϵ, B, xs, ηs)
    @assert sum(ηs) ≈ 1
    if sum(ηs .* abs.(xs).^(1+ϵ)) ≤ B
        return xs, ηs # inside L already
    end

    function sortpair(xs, ys)
        I = sortperm(xs);
        (xs[I], ys[I]);
    end

    # 0 is special here, as it minimises abs(.)^(1+ϵ)
    (xl, ηl) = sortpair(xs[xs .< 0], ηs[xs .< 0]);
    (xh, ηh) = sortpair([0, xs[xs .≥ 0] ...], [0, ηs[xs .≥ 0] ...]);
    Fl = cumsum(ηl);
    Fh = sum(ηl) .+ cumsum(ηh);
    xout = [xl ..., xh ...];

    function ηout(z)
        diff([0, max.(0, Fl .- z) ..., min.(1, Fh .+ z) ...])
    end

    z = binary_search(z -> B - sum(ηout(z) .* abs.(xout).^(1+ϵ)), 0, 1);

    return xout, ηout(z)
end


# test on random example checked by matlab
@testset "Kolmogorov (sup norm) projection" begin
    xs = [
        -1.000000, -0.916667, -0.833333, -0.750000, -0.666667, -0.583333, -0.500000, -0.416667, -0.333333, -0.250000, -0.166667, -0.083333, 0.000000, 0.083333, 0.166667, 0.250000, 0.333333, 0.416667, 0.500000, 0.583333, 0.666667, 0.750000, 0.833333, 0.916667, 1.000000]
    ηs = [0.000000, 0.000000, 0.000000, 0.014608, 0.091389, 0.000000, 0.035712, 0.263251, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.022994, 0.064397, 0.000000, 0.000000, 0.000000, 0.000000, 0.000263, 0.000000, 0.356515, 0.084864, 0.000000, 0.066007];

    outxs, outηs = kolm_proj(1, .1, xs, ηs)

    qs = [0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.054811, 0.000000, 0.000000, 0.000000, 0.000000, 0.700296, 0.022994, 0.064397, 0.000000, 0.000000, 0.000000, 0.000000, 0.000263, 0.000000, 0.157238, 0.000000, 0.000000, 0.000000];

    for x in sort([xs ..., outxs...])
        @test sum(qs[xs.==x]) ≈ sum(outηs[outxs.==x]) atol=1e-5
    end
end
