using JLD2;
using Plots;

include("experiment_helpers.jl")

δs =[];

global x=[];
global y=[];

filepath = isempty(ARGS) ? "output/" : ARGS[1];
if length(ARGS) > 1
    fromArms, toArms = parse.(Int64, (ARGS[2], ARGS[3]));
else
    fromArms, toArms = (2,21);
end

for i in fromArms:toArms
    filename = string(filepath,"experiment",i,".dat");
    @load filename B θ ϵ MAB δs βs myrange seed data j
    @assert i == j "$(i), $(j) mismatch!"; 
    N=length(myrange);
    dlen = length(δs);
    global δs = δs;
    
    if y==[]
        global y=zeros(dlen);
    end
    
    println("narms=$(j), No. of exp=$(N), No. of deltas=$(dlen)");
    
    sc = [sum(sum.(getindex.(getindex.(data, j),2)))/length(sum.(getindex.(getindex.(data, j),2))) for j in eachindex(δs)]
    
    global x= [x... j];
    global y= [y sc];
end

x=[x' for j in eachindex(δs)];

y=y[:,2:size(y)[2]]
p=plot(x,y',fmt = :pdf, legendtitle="δ", label=[δs...]', title = string("Empirical Sample Complexity vs Number of Arms "), xlabel="No. of arms", ylabel="Avg. stopping time",legend=:topleft, lw=2, left_margin=7Plots.mm, bottom_margin=5Plots.mm);
savefig(p, string(filepath,"sc_MA.pdf"));
