<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Knapsack Problem</title>
    <link rel="icon" type="image/gif" sizes="32x32" href="./static/img/icon.png">
    <!-- CSS only -->
    <link href="./static/bootstrap/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="./static/css/styles.css" rel="stylesheet">
    <link href="./static/css/signup.css" rel="stylesheet">
       

    <!-- server side codes -->
    <?php require './db/config.php';?>    
</head>

<body>
<div class="wrapper">

    <nav class="navbar navbar-expand-md navbar-dark">

        <div class="container-fluid">
            <div class="left">
                <a class="navbar-brand">
                    <img src="./static/img/mpg-logo-new.png">
                </a>
                <div class="vertical"></div>
                <div class="nav-item ps-2 header" id="upload">Knapsack Problem</div>
            </div>
        </div>
    </nav>

    <div id="myCarousel" class="carousel slide signup-h" data-bs-interval="false">
        <div class="carousel-inner">
            <div class="carousel-item active" id="prolific">
                <form class="container" id="prolific-id-form">
                    <br>
                    <h4 class="mt-3">Please enter your Prolific Id:</h4>
                    <!-- <p class="mb-1">Please enter your prolific id:</p> -->
                    <div class="row">
                        <div class="col-md-8 col-12">
                            <input class="form-control" id="prolific-id" placeholder="prolific id">
                        </div>
                        <h3>Please make sure that your browser window has a resolution of at least 1000x750 pixels at all times during your participation. Otherwise, you will not be able to participate in this study.
                        </h3>
                        <div id="device-too-small"><h3 style="color: red;">Your browser window is currently smaller than 1000x750 pixels. If you do not have a device with this resolution, please go back to prolific and return the study.</h3>
                        </div>
                        <div id="device-ok"><h3 style="color: darkgreen;">Your browser window has an appropriate size. You can participate!</h3>
                        </div>
                        <div class="col-md-4 col-12">
                            <button type="button" class="col-12 mx-auto btn btn-primary" onClick="check_prolific_id()">Next</button> 
                        </div>
                    </div>
                </form>
            </div>
            <div class="carousel-item" id="consent">
                <div class="container text-start">
                    <h1 class="mt-3">Consent Form</h1>
                    <p class="mb-1">
                        Please read the description of this reserach study carefully.
                    </p>
                    <br>
                    <p class="disabled-consent mb-1">
                    This study explores the role of machine learning on human performance in solving hard problems. 
                    If you choose to participate in the study, you will be guided through a tutorial explaining the type of problems you will be solving, and then  you will be asked to solve two practice problems.
                    After the tutorial, you will be  asked to solve 10 problems, each with a time limit of 3 minutes.
                    At the conclusion of the study, you will be asked a few questions about yourself.
                    You can decide to drop out of the study at any time. Your decision will not be held against you.

                    For more detailed information on the data collection and processing methods, please refer to our <a href="privacypolicy.php" target=”_blank>Privacy Policy</a>. <br>If you have any further questions, please contact us via email:
                        <br><br><i>retracted for double blind review<br>
                        retracted for double blind review</i>
                        <br>
                        <br>
                    </p>
                    <br>
                    <div class="form-check mb-3">
                        <input class="form-check-input" type="checkbox" name="consent-radio-1" value="" id="consent-radio-1">
                        <label class="form-check-label" for="consent-radio-1">
                            I declare that I am aware of the scope of the study as described above and the personal data recorded for the study.
                        </label>
                    </div>
                    <div class="form-check mb-3">
                        <input class="form-check-input" type="checkbox" name="consent-radio-2" value="" id="consent-radio-2">
                        <label class="form-check-label" for="consent-radio-2">
                            I have received and understood the <a href="dpis.php" target=”_blank>Data Protection Information Sheet</a>.
                        </label>
                    </div>
                    <div class="form-check mb-3">
                        <input class="form-check-input" type="checkbox" name="consent-radio-3" value="" id="consent-radio-3">
                        <label class="form-check-label" for="consent-radio-3">
                            I declare my consent for the participation in this study according to the <a href="doc.php" target=”_blank>Declaration of Consent under Data Protection Regulations</a>.
                        </label>
                    </div>
                    <div class="form-check mb-3">
                        <input class="form-check-input" type="checkbox" name="consent-radio-4" value="" id="consent-radio-4">
                        <label class="form-check-label" for="consent-radio-4">
                            I am at least 18 years old.
                        </label>
                    </div>
                    <button class="btn btn-primary col-12 col-md-4 fit-to-right" type="button" onClick="check_consent()">Confirm</button>
                </div>
            </div>
            
        </div>
    </div>
</div>

    <div id="my-footer" class="mt-5 signup-my-footer">
        <div class="copyright custom-copyright">
            <div class="container">
                <div class="row mx-auto">
                    <div class="col-md-12">
                        <p style="color : #3E497A">
                            © 2023 Max-Planck-Gesellschaft -
                            <span class="custom-copyright-container">
                                <a href="retracted for double blind review" target=”_blank>Imprint</a> |
                                <a href="privacypolicy.php" target=”_blank>Privacy Policy</a>
                            </span>
                        </p>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <!-- <script src="//ajax.googleapis.com/ajax/libs/jquery/1.6.4/jquery.min.js"></script> -->
    <script src="./static/jquery/jquery-1.6.4.js"></script>
    <script src="./static/js/scripts.js"></script>
    <script src="./static/js/signup.js"></script>
    <!-- JavaScript Bundle with Popper -->
    <!-- <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js" -->

    <script src="./static/bootstrap/dist/js/bootstrap.bundle.min.js" crossorigin="anonymous">
    </script>
</body>

</html>
