import pdd
import numpy as np

if __name__ == '__main__':

    trapezium = np.array([[0,0],[1,1],[3,1],[4,0]])
    kite = np.array([[0,0],[1,1],[1,-1],[4,0]])

    trap_pdd = pdd.pdd_finite(trapezium)
    kite_pdd = pdd.pdd_finite(kite)

    print('trapezium:', [tuple(p) for p in trapezium])
    print('PDD:')
    print(trap_pdd, '\n')

    print('kite:', [tuple(p) for p in kite])
    print('PDD:')
    print(kite_pdd, '\n')

    dist = pdd.emd(trap_pdd, kite_pdd)

    print('EMD between trapezium and kite:', dist)
