import argparse
import pdd

if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('--k', type=int)
    args = parser.parse_args()
    
    if args.k is None:
        k = 100
    else:
        k = args.k
    
    path_1 = 'CIFs_T2-crystals/T2-0014.cif'
    path_2 = 'CIFs_T2-crystals/T2-0015.cif'
    crystal_1 = pdd.read_cif(path_1)
    crystal_2 = pdd.read_cif(path_2)
    
    pdd_1 = pdd.pdd(crystal_1, k)
    pdd_2 = pdd.pdd(crystal_2, k)
    
    print(crystal_1.name, ':', crystal_1.motif.shape[0], 'points in a unit cell with parameters', crystal_1.cellpar)
    print(f'PDD (k={k}):')
    print(pdd_1, '\n')
    print(crystal_2.name, ':', crystal_2.motif.shape[0], 'points in a unit cell with parameters', crystal_2.cellpar)
    print(f'PDD (k={k}):')
    print(pdd_2, '\n')
    
    emd = pdd.emd(pdd_1, pdd_2)
    print(f'EMD distance (k={k}) between {crystal_1.name} and {crystal_2.name}:', emd)