import torch
from torchmetrics.multimodal.clip_score import CLIPScore
import yaml
import torchvision.transforms as transforms
from dataset import FFHQDataset
from torchvision import transforms
from torch.utils.data import DataLoader
import numpy as np
from tqdm import tqdm

label_folder = ''

transform = transforms.Compose([transforms.ToTensor()])

label_set = FFHQDataset(label_folder, transform)

label_loader = list(DataLoader(label_set, 1))

metric = CLIPScore(model_name_or_path="./bins/openai/clip-vit-large-patch14").cuda()
score_collection = []

file = open("")
file_content = file.readlines()

def imgaug(img):
    img = img * 2 - 1
    img = img + torch.randn_like(img) * 0.2
    img = (img + 1) / 2
    return img

with torch.no_grad():
    for i,img in tqdm(enumerate(label_loader)):
        img = img.cuda()
        img = imgaug(img)
        score = metric(img, file_content[i].split('\'')[1])
        score = score.cpu().numpy()
        score_collection.append(score)
    print(np.mean(score_collection))
    
