import argparse
import torch
import os
import json
from tqdm import tqdm
import shortuuid
import sys
import os

sys.path.append(os.path.dirname(os.path.dirname(os.path.dirname(os.path.abspath(__file__)))))
sys.path.append(os.path.dirname(os.path.dirname(os.path.abspath(__file__))))
# print(os.path.dirname(os.path.dirname(os.path.dirname(os.path.abspath(__file__)))))
from llava.constants import (
    IMAGE_TOKEN_INDEX, # IMAGE_TOKEN_INDEX = -200
    DEFAULT_IMAGE_TOKEN, # DEFAULT_IMAGE_TOKEN = "<image>"
    DEFAULT_IM_START_TOKEN, # DEFAULT_IM_START_TOKEN = "<im_start>"
    DEFAULT_IM_END_TOKEN, # DEFAULT_IM_END_TOKEN = "<im_end>"
    IMAGE_PLACEHOLDER, # IMAGE_PLACEHOLDER = "<image-placeholder>"
)
from llava.conversation import conv_templates, SeparatorStyle
from llava.model.builder import load_pretrained_model
from llava.utils import disable_torch_init
from llava.mm_utils import tokenizer_image_token, process_images, get_model_name_from_path, KeywordsStoppingCriteria

from PIL import Image
import base64
import requests

from io import BytesIO
import re
import math
import torch.distributed as dist
from utils import dist_util
from utils.logger import create_logger
from glob import glob
from transformers import set_seed


def image_parser(args):
    out = args.image_file.split(args.sep)
    return out


def load_image(image_file):
    # 预处理
    if image_file.startswith("http") or image_file.startswith("https"):
        response = requests.get(image_file)
        image = Image.open(BytesIO(response.content)).convert("RGB")
    else:
        image = Image.open(image_file).convert("RGB")
    return image


def load_images(image_files):
    # 图片列表
    out = []
    for image_file in image_files:
        image = load_image(image_file)
        out.append(image)
    return out





def eval_model(args):
    
    # set up gpu and logging
    
    dist_util.setup_dist(args)
    device = dist_util.device()

    # Setup an experiment folder:
    if dist.get_rank() == 0:
        os.makedirs(
            args.log_path, exist_ok=True
        )  # Make results folder (holds all experiment subfolders)
        model_string_name = args.model_path.split("/")[-1]
        experiment_index = len(glob(f"{args.log_path}/{model_string_name}/*"))
        experiment_dir = f"{args.log_path}"  # Create an experiment folder
        os.makedirs(experiment_dir, exist_ok=True)
        logger = create_logger(experiment_dir)
        logger.info(f"Experiment directory created at {experiment_dir}")
    else:
        logger = create_logger(None)
    # logger.info(f"use_cd: {args.use_cd}, method: {args.use_avisc}, layer_gamma: {args.layer_gamma}, masking_scheme: {args.masking_scheme}, lamb: {args.lamb}")
    logger.info(f"question_file : {args.question_file}")


    
    
    # Model
    disable_torch_init()
    model_path = os.path.expanduser(args.model_path)
    model_name = get_model_name_from_path(model_path)
    tokenizer, model, image_processor, context_len = load_pretrained_model(model_path, args.model_base, model_name,device="cuda:5")

    # questions = [json.loads(q) for q in open(os.path.expanduser(args.question_file), "r")]
    # questions = get_chunk(questions, args.num_chunks, args.chunk_idx)
    with open(args.question_file, "r", encoding="utf-8") as f:
        query_list_data = json.load(f) 
    
    # answers_file = os.path.expanduser(args.answers_file)
    # # os.makedirs(os.path.dirname(answers_file), exist_ok=True)
    # ans_file = open(answers_file, "a")

    
    with open(".../OPERA/log/chair_eval_results/llava-1.5/ours.jsonl", "r", encoding="utf-8") as f:
        for _, data_line in tqdm(enumerate(f.readlines()),total=500):
            line = json.loads(data_line)
            idx = line["image_id"]
            image_file = ".../val2014/COCO_val2014_" + str(idx).zfill(12) + ".jpg"
            qs = "Please describe this image in detail."#line["query"]
            cur_prompt = qs
    
            if model.config.mm_use_im_start_end:
                qs = DEFAULT_IM_START_TOKEN + DEFAULT_IMAGE_TOKEN + DEFAULT_IM_END_TOKEN + '\n' + qs
            else:
                qs = DEFAULT_IMAGE_TOKEN + '\n' + qs

            conv = conv_templates[args.conv_mode].copy()
            conv.append_message(conv.roles[0], qs)
            conv.append_message(conv.roles[1], None)
            prompt = conv.get_prompt()

            input_ids = tokenizer_image_token(prompt, tokenizer, IMAGE_TOKEN_INDEX, return_tensors='pt').unsqueeze(0).cuda(5)
            image = Image.open(os.path.join(args.image_folder, image_file))
            image_tensor = image_processor.preprocess(image, return_tensors='pt')['pixel_values'][0]            
            stop_str = conv.sep if conv.sep_style != SeparatorStyle.TWO else conv.sep2
            keywords = [stop_str]
            stopping_criteria = KeywordsStoppingCriteria(keywords, tokenizer, input_ids)

            with torch.inference_mode():
                with torch.no_grad():
                    output_dict = model.generate(
                        input_ids,
                        images=image_tensor.unsqueeze(0).half().cuda(5),
                        do_sample=True if args.temperature > 0 else False,
                        temperature=args.temperature,
                        top_p=args.top_p,
                        num_beams=args.num_beams,
                        max_new_tokens=args.max_new_tokens,
                        return_dict_in_generate=True,
                        output_hidden_states=True,
                        stopping_criteria=[stopping_criteria],
                        # repetition_penalty=1.5,
                        use_deco = True,
                        alpha = 0.6,
                        threshold_top_p = 0.9, 
                        threshold_top_k = 20,
                        early_exit_layers=[i for i in range(20, 29)],
                        return_dict=True
                        )
                
            output_ids = output_dict.sequences
            input_token_len = input_ids.shape[1]
            outputs = tokenizer.batch_decode(
                    output_ids[:, input_token_len:], skip_special_tokens=True
                )[0]
            outputs = outputs.strip()
                
                
            logger.info(f"[{image_file}]")
            logger.info(f"prompt: {cur_prompt}") 
            logger.info(f"text: {outputs}")  
            res_dict = {"id": idx,"response": outputs}
            # ans_file.write(json.dumps(res_dict, ensure_ascii=False) + "\n")
                


if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("--model-path", type=str, default=".../llava-v1.5-7b")
    parser.add_argument("--model-base", type=str, default=None)
    parser.add_argument("--image-folder", type=str, default=".../MME_Benchmark_release_version")
    parser.add_argument("--question-file", type=str, default=".../AMBER/data/query/query_generative.json")
    parser.add_argument("--answers-file", type=str, default="")
    parser.add_argument("--conv-mode", type=str, default="llava_v1")
    parser.add_argument("--num-chunks", type=int, default=1)
    parser.add_argument("--chunk-idx", type=int, default=0)
    parser.add_argument("--temperature", type=float, default=-1) # 可以考虑调大温度试试
    parser.add_argument("--top_p", type=float, default=None)
    parser.add_argument("--top_k", type=int, default=None)
    parser.add_argument("--num_beams", type=int, default=1)
    parser.add_argument("--max_new_tokens", type=int, default=512)
    parser.add_argument("--log_path", type=str, default="...")
    parser.add_argument("--batch_size", type=int, default=1)
    parser.add_argument("--noise_step", type=int, default=500)
    parser.add_argument("--cd_alpha", type=float, default=1)
    parser.add_argument("--cd_beta", type=float, default=0.1)
    parser.add_argument("--seed", type=int, default=42)

    args = parser.parse_args()
    set_seed(args.seed)
    eval_model(args)
