import sys
from .ordered_easydict import OrderedEasyDict as edict
import numpy as np
import os
import torch

__C = edict()
cfg = __C
__C.GLOBAL = edict()
__C.GLOBAL.DEVICE = torch.device("cuda" if torch.cuda.is_available() else "cpu")
__C.GLOBAL.BATCH_SIZE = 1
for dirs in ['/here/is/code/M2F-PINN', 'yourpath']:
    if os.path.exists(dirs):
        __C.GLOBAL.PATH = dirs
assert __C.GLOBAL.PATH is not None
__C.GLOBAL.SEED = 99
__C.GLOBAL.NUM_STREADS = 16

__C.PG_INPUT_PATH = '/home/code/is/your/data'
assert __C.PG_INPUT_PATH is not None

__C.PG_OUT_PATH = os.path.join(__C.GLOBAL.PATH, 'result')
assert __C.PG_OUT_PATH is not None

__C.ERA5_UPPER_LEVELS = ['1000', '925', '850', '700', '600', '500', '400', '300', '250', '200', '150', '100', '50']
__C.ERA5_UPPER_VARIABLES = ['uo', 'vo']

__C.PG = edict()

__C.PG.TRAIN = edict()

__C.PG.HORIZON = 24

__C.PG.TRAIN.EPOCHS = 100
__C.PG.TRAIN.LR = 1e-4
__C.PG.TRAIN.WEIGHT_DECAY = 3e-6
__C.PG.TRAIN.START_TIME = '20050101120000'
__C.PG.TRAIN.END_TIME = '20051231120000'
__C.PG.TRAIN.FREQUENCY = '24H'
__C.PG.TRAIN.BATCH_SIZE = 2
__C.PG.TRAIN.UPPER_WEIGHTS = [3.24, 3.63]
__C.PG.TRAIN.SAVE_INTERVAL = 1
__C.PG.VAL = edict()

__C.PG.VAL.START_TIME = '20060101120000'
__C.PG.VAL.END_TIME = '20060831120000'
__C.PG.VAL.FREQUENCY = '24H'
__C.PG.VAL.BATCH_SIZE = 2
__C.PG.VAL.INTERVAL = 1

__C.PG.TEST = edict()

__C.PG.TEST.START_TIME = '20060903120000'
__C.PG.TEST.END_TIME = '20060910120000'
__C.PG.TEST.FREQUENCY = '24H'
__C.PG.TEST.BATCH_SIZE = 1

__C.PG.BENCHMARK = edict()

__C.PG.BENCHMARK.PRETRAIN_24 = os.path.join(__C.PG_INPUT_PATH, 'pretrained_model/pangu_weather_24.onnx')

__C.MODEL = edict()

__C.FOURIER = edict()
__C.FOURIER.FF_ENABLED = True
__C.FOURIER.FF_INPUT_DIMS = 3
__C.FOURIER.FF_MAPPING_SIZE_LOW = 16
__C.FOURIER.FF_MAPPING_SIZE_HIGH = 16
__C.FOURIER.FF_SCALE_LOW = 0.1
__C.FOURIER.FF_SCALE_HIGH = 1.0
__C.FOURIER.FF_HIDDEN_DIM = 32
