
# Code for Self-Exploring Language Models (SELM)

Code for NeurIPS submission Self-Exploring Language Models: Active Preference Elicitation for Online Alignment.

## Run the Code

To run the code in this project, first, create a Python virtual environment using e.g. Conda:

```shell
conda create -n selm python=3.10 && conda activate selm
```

Next, install PyTorch `v2.1.2` - the precise version is important for reproducibility! Since this is hardware-dependent, we
direct you to the [PyTorch Installation Page](https://pytorch.org/get-started/locally/).

You can then install the remaining package dependencies as follows:

```shell
 python -m pip install .
```

You will also need Flash Attention 2 installed, which can be done by running:

```shell
python -m pip install flash-attn --no-build-isolation
```

> **Note**
> If your machine has less than 96GB of RAM and many CPU cores, reduce the `MAX_JOBS` arguments, e.g. `MAX_JOBS=4 pip install flash-attn --no-build-isolation`

Next, log into your Hugging Face account as follows:

```shell
huggingface-cli login
```

Finally, install Git LFS so that you can push models to the Hugging Face Hub:

```shell
sudo apt-get install git-lfs
```

To train SELM with [Meta-Llama-3-8B-Instruct](https://huggingface.co/meta-llama/Meta-Llama-3-8B-Instruct), you need to first apply for the access.

Replace `USERNAME` in run_zephyr.sh and run_llama.sh with your huggingface username.
After the above preparation, run the following command:

```shell
sh run_zephyr.sh
```

or

```shell
sh run_llama.sh
```

## Credit

Our codebase is adapted from the [Huggingface Alignment Handbook](https://github.com/huggingface/alignment-handbook). 