#!/bin/bash

# List of methods to iterate over
# methods=('integratedgrad' 'saliency' 'smoothgrad' 'gradcam' 'wcam')
methods=('wcam')


# Iterate over each method
for method in "${methods[@]}"
do
  # Run the command with noise set to False
  echo "Running: --source_dir=\"../drafts\" --method=\"$method\" --batch_size=8 --noise=False"
  python evaluate_1d.py --source_dir="../drafts" --method="$method" --batch_size=8 --noise=False

  # Run the command with noise set to True
  echo "Running: --source_dir=\"../drafts\" --method=\"$method\" --batch_size=8 --noise=True"
  python evaluate_1d.py --source_dir="../drafts" --method="$method" --batch_size=8 --noise=True
done
