#!/bin/bash

# Prompt user to input the batch size
read -p "Enter the batch size: " batch_size

# Prompt user to input the memory limit in GB
read -p "Enter the memory limit in GB (e.g., 4 for 4GB): " memory_limit_gb

# Convert the memory limit from GB to KB (ulimit uses KB)
memory_limit_kb=$((memory_limit_gb * 1024 * 1024))

# Set the memory limit using ulimit
ulimit -v $memory_limit_kb

# List of tuples containing (model, method, metric)
# model indicates the model on which evaluation is carried out, the method indicates the XAI method 
# evaluated and the metric indicates which metric is computed to evaluate the method on the model. 

# if we set none, then we run all the metrics (mu_fidelity, insertion and deletion)

model_method_metric_pairs=(


    #"efficientnet gradcam insertion"  
    "efficientnet gradcampp insertion"  

    "efficientnet gradcam deletion"  
    "efficientnet gradcampp deletion"  

)

# not implemented yet: the remaining metrics and the variant of the WCAM. 

# Loop through each (model, method, metric) tuple
for pair in "${model_method_metric_pairs[@]}"
do
    # Extract model, method, and metric from the tuple
    model=$(echo $pair | awk '{print $1}')
    method=$(echo $pair | awk '{print $2}')
    metric=$(echo $pair | awk '{print $3}')

    # Check if metric is "None"
    if [ "$metric" == "None" ]; then
        # Run the Python script without the --metric argument
        python evaluate_2d.py --source_dir="../../data/ImageNet/benchmark" --model=$model --method=$method --batch_size=$batch_size
    else
        # Run the Python script with the --metric argument
        python evaluate_2d.py --source_dir="../../data/ImageNet/benchmark" --model=$model --method=$method --metric=$metric --batch_size=$batch_size
    fi
done
