function errors = ...
    error_general_LRJS(X0,opts,outs,alg_name,varargin)
%error_general_LRJS Calculates the relevant errors for the output of
%algorithms of the low-rank + row sparsity problem

% The parameter 'print_output' determines if we additionally display some
% error numbers:
%%% 'print_output == 1' means that we display something.
%%% 'print_output == 0' means that we display _nothing_.

%   Input:   X0 = Matrix to be recovered, size (d1 x d2)
%  X_iterationl = Approximate matrix of current iteration, size (d1 x d2) 
%            T0 = Index set of the row support of X0
%[d,m_chi]   = size(X0);

% T0 
% IRLS_ind = find(contains(alg_name,'IRLS-LRRS'));
% 
% % if opts{IRLS_ind}.usestabplot
% if length(IRLS_ind) > 1
%     error_IRLS_stab = cell(1,length(IRLS_ind));
%     for k = 1:length(IRLS_ind)
%         for i=1:opts{IRLS_ind(k)}.gridsize
%             error_IRLS_stab{k}(i)=norm(outs{IRLS_ind(k)}.Xhat{i} - X0);
%         end
%     end
% elseif IRLS_ind == 1
%     for i=1:opts{IRLS_ind}.gridsize
%         error_IRLS_stab(i)=norm(outs{IRLS_ind}.Xhat{i} - X0);
%     end
%     error_IRLS_stab
% end
% end

%% Report errors
nr_algos=length(alg_name);
errors = struct;
errors.fro          = cell(1,nr_algos);
errors.fro_rel      = cell(1,nr_algos);

% error_inf_rel = cell(1,nr_algos);
for l=1:nr_algos
    if isfield(outs{l},'X') && iscell(outs{l}.X)
        N = length(outs{l}.X);
    else
        N = 1;
    end
    for k=1:N
        if isfield(outs{l},'X') && iscell(outs{l}.X)
            X_c = outs{l}.X{k};
        else
            X_c = outs{l}.X;
        end
        errors.fro{l}(k)=norm(X_c-X0,'fro');
        errors.fro_rel{l}(k)=errors.fro{l}(k)./norm(X0,'fro');
%         error_inf_rel{l}(i)=norm(X_c-X0)./norm(X0);
    end
    display(alg_name{l});
    if (iscell(opts) && isfield(opts{l},'verbose') && opts{l}.verbose) || (isfield(opts,'verbose') && opts.verbose)
        disp(['Frobenius norm error to X0:      ',num2str(errors.fro{l}(end))]);
        disp(['Relative Frob. error to X0:      ',num2str(errors.fro_rel{l}(end))]);
%         disp(['Spectral norm error to X0:       ',num2str(error_inf_rel{l}(end))]);
    end
   
    %hold on
end


end