function [Phi] = SampleGaussianPhi_matrix(d,m_chi,m,std_dev)
%SampleGaussianPh: This function samples N(0,std_dev^2) i.i.d. entries on
% m_chi matrices Phi^(1),...Phi^(m_chi) that have the size (m_phi x d).

%           Input:
%           d       = Number of rows of matrix to be recovered
%           m_chi   = Number of columns of matrix to be recovered 
%           m       = Number of measurements
%           std_dev = Standard deviation of entries (standard should be 1)
%          
%
%           Output:
%           Phi     = (m x (d*m_chi)) matrix           

Phi = zeros(m,d*m_chi);

n1=normrnd(0,std_dev,m,d*m_chi);
Phi = n1;

end
