function Vmat = compute_Vmat_LRRS(Phi,W_1_diag_c,lambda,weight_op,d1,d2,fac)
%compute_Vmat_LRRS Compute an auxiliary matrix for IRLS for simultaneously
% low-rank and row-sparse recovery.
m = size(Phi,1);
Mat = ((fac.*(lambda./weight_op.S_c_eps+W_1_diag_c)).^(-1)).*Phi';
handle_action = @(y) matrixspace_to_tangspace(reshape(Mat*y,d1,d2),weight_op);
handle_matrixaction = @(Y) cell2mat(cellfun(handle_action,num2cell(Y,1),'UniformOutput',false));
Vmat = handle_matrixaction(speye(m));
%cell2mat(cellfun(A,num2cell(X,1),'UniformOutput',false));
end