%Test File for SPF versions

%% Parameters

n1 = 16;
n2 = 100;
rank = 2;

s1 = 1;
s2 = 0.1;

NrMeas  = rank*[40:10:120];
NrOfX   = 1;
ErrorMatrix = zeros(NrOfX,length(NrMeas));

N0 = 50;
noise = 0.2;

%% Create Measurements

for k = 1:length(NrMeas)
    
    A = randn(NrMeas(k),n1*n2)/(NrMeas(k)^0.5);
    
    %% Create X and y (with noise)
    
    for l = 1:NrOfX
        
        X = createSparseRandomLowRankInputCommonSupport(n1,n2,rank,s2);
        y = A*X(:);
        eps = randn(NrMeas(k),1); eps = (eps/norm(eps))*(norm(y)*noise);
        y = y + eps;
        
        %% Initialize and Recover with SPF
        
        [U0,V0] = StartValue(y,A,n1,n2,rank);
        [U,V] = rSPF(A,y,n1,n2,rank,s1,s2,U0,V0,N0);
        
        %% Update Error Matrix
        
        ErrorMatrix(l,k) = norm(X-U*V','fro')/norm(X,'fro');
    
    end
end

%% Output

ErrorMatrix
        