load('LRRS_Gaussian_rank5_convg_plot.mat')
alg_names = get_good_algo_names(Example.alg_name);

visualize_errorcurves_combined(outs.errors.fro_rel,alg_names,'titlestring','');

ylabel('Rel. Frobenius error')
xlabel('Iteration $k$')

%% Save
filename=strcat('results/experiment_cvgplot_rank5');
savefig(strcat(filename,'.fig'))
fig=gcf;
saveas(fig,strcat(filename,'.eps'),'epsc')
saveas(fig,strcat(filename,'.pdf'))
if exist('matlab2tikz')
    cleanfigure; 
    matlab2tikz(strcat(filename,'.tex'),'height', '\figureheight', 'width', '\figurewidth',...
    'extraaxisoptions',['xlabel style={font=\tiny},',...
    'ylabel style={font=\tiny},'])
end