function stats = analyze_rankobjectives_linearrate(outs,X0,r)

nr_algos = length(outs);
stats = cell(1,nr_algos);
% Sc = setdiff([1:length(x0)],S);
[U0,S0,V0]=svd(X0);
s0 = diag(S0);
sing_X0_min = s0(r);
nucnorm_X0 = sum(s0);
for l=1:nr_algos
    stats{l} = struct;
    stats{l}.N = outs{l}.N;
    stats{l}.normx0 = nucnorm_X0;
    stats{l}.d = min(size(X0,1),size(X0,2));
    stats{l}.rho_DDFG = zeros(1,outs{l}.N);
    stats{l}.variant_fac = cell(1,outs{l}.N);
%     stats{l}.SkcapS = cell(1,outs{l}.N); % this should become some sort of principal angle between T0 and Tk
    for k = 1:stats{l}.N
%         [~,ind]=sort(abs(outs{l}.x{k}),'descend');
%         Sk = sort(ind(1:length(S)));
%         Sk   = outs{l}.x{k}(ind_absE);
%     stats{l}.SkcapS{k} = intersect(S,Sk); % this should become some sort of principal angle between T0 and Tk
%         stats{l}.supportcorrect(k) = length(stats{l}.SkcapS{k});
        stats{l}.normdiff_spectral(k) = outs{l}.XminX0spectral(k);
        stats{l}.normdiff_S1(k) = outs{l}.XminX0nuclear(k);
%         stats{l}.normdiff_l1_S(k) = norm(outs{l}.x{k}(S)-x0(S),1);
%         stats{l}.normdiff_l1_Sc(k) = norm(outs{l}.x{k}(Sc)-x0(Sc),1);
        stats{l}.JminX0S1(k) = outs{l}.obj_epsA(k) -  stats{l}.normx0;
        stats{l}.Jval(k) = outs{l}.obj_epsB(k);
        stats{l}.Jval_beforeeps(k) = outs{l}.obj_epsA(k);
        stats{l}.rho_DDFG(k) = stats{l}.normdiff_S1(k)./sing_X0_min;
%         stats{l}.linconst_p1{k} = abs(outs{l}.x{k}(S)-x0(S))./abs(outs{l}.x{k}(S));
%         stats{l}.linconst_p2{k} = abs(outs{l}.x{k}(S)-x0(S))./abs(outs{l}.eps(k));
%         stats{l}.rho_KMS(k) = max(min(stats{l}.linconst_p1{k},stats{l}.linconst_p2{k}));
        if k > 1
            stats{l}.muest(k) = stats{l}.JminX0S1(k)./stats{l}.JminX0S1(k-1);
            stats{l}.muest_S1(k) = stats{l}.normdiff_S1(k)./stats{l}.normdiff_S1(k-1);
%             stats{l}.oneminoneovermuest(k) = %stats{l}.d*(1 - stats{l}.muest(k));
            stats{l}.oneminoneovermuest(k) = (1 - stats{l}.muest(k));
        else
            stats{l}.muest_S1(k) = Inf;
            stats{l}.muest(k) = Inf;
            stats{l}.oneminoneovermuest(k) = Inf;
        end
    end
end

% fieldname = 'muest';
%ylabel = 'Estimates for \mu';

end

