%Test File for SPF versions

%% Parameters

dx1 = 16;
dx2 = 100;
rank = 1;

alpha = 0;
beta = 0.5;

s = 0.1;

NrMeas  = rank*[50:20:150];
NrOfX   = 30;
ErrorMatrixSPF = zeros(NrOfX,length(NrMeas));
ErrorMatrixLRAS = zeros(NrOfX,length(NrMeas));

N0 = 50;
normOfX = 10;
noise = 0.0;

%% Create Measurements

for k = 1:length(NrMeas)
    
    k
    A = randn(NrMeas(k),dx1*dx2)/(NrMeas(k)^0.5);
    
    %% Create X and y (with noise)
    
    for l = 1:NrOfX        
        
        X = createSparseRandomLowRankInputCommonSupport(dx1,dx2,rank,s);
        nrmX = norm(X,'fro');
        X = X*normOfX/nrmX;
        y = A*X(:);
        eps = randn(NrMeas(k),1); eps = (eps/norm(eps))*(norm(y)*noise);
        y = y + eps;
        
        %% Initialize and Recover with SPF and LRAS
        
        [U0,V0] = StartValue(y,A,dx1,dx2,rank);
%         U0 = randn(dx1,1);
%         V0 = randn(dx2,1);
        [Uspf,Vspf] = rSPF(A,y,dx1,dx2,rank,1,s,U0,V0,N0);
        
%         y = getMeasurement(X,A);
%         eps = randn(NrMeas(k),1); eps = (eps/norm(eps))*(norm(y)*noise);
%         y = y + eps;
%         [Ulras,Slras,Vlras] = LRAS(y,A,alpha,beta,U0,V0,N0,rank);
        
        %% Update Error Matrices
        
        ErrorMatrixSPF(l,k) = norm(X-Uspf*Vspf','fro')/norm(X,'fro');
        %ErrorMatrixLRAS(l,k) = norm(X-Ulras*eye(dx1,dx2)*Vlras','fro')/norm(X,'fro');
    
    end
end

%% Output

ErrorMatrixSPF
ErrorMatrixLRAS
        