Examples   = LoadExampleDefinitions;
Params.ExampleName = 'LRRS_Gaussian_rank5_obj_tracking';
ExampleIdx = SelectExample(Params,Examples);
Example    = Examples{ExampleIdx};

disp(Example.prob)
% disp(Example.prob.graphmodel)
disp(Example.samplemodel)

[yr,outs] = run_methods_LRRS(Example);

%% Save data
s1=Example.descr;
s3='.mat';
filename = strcat(s1,s3);
save(strcat('experiments/',filename),'Example','outs','yr');
figure(outs.objfigure);
savefig(strcat('experiments/',s1,'.fig'));
fig=gcf;
saveas(fig,strcat('experiments/',s1,'.eps'),'epsc')
saveas(fig,strcat('experiments/',s1,'.pdf'))
if exist('matlab2tikz')
    cleanfigure; 
    matlab2tikz(strcat('experiments/',s1,'.tex'),'height', '\figureheight', 'width', '\figurewidth',...
    'extraaxisoptions',['xlabel style={font=\tiny},',...
    'ylabel style={font=\tiny},'])
end
% s2=convertCharsToStrings(Example.prob.normalization);
% if islogical(s2)
%     s2 = "false";
% end