function [ X ] = createSparseRandomLowRankInput( n1,n2,rank,sparsity,singularValues )
%   Creates random X with sparse right singular vectors
%
%   n1,n2           -       Dimensions of X
%   rank            -       Rank of X
%   sparsity        -       Sparsity on right singular vectors relative to n2
%   singularValues  -       Vector of wished singular vectors (optional)


    X = zeros(n1,n2);
    u = zeros(n1,rank);
    v = zeros(n2,rank);
    
    s = floor(sparsity*n2);
    
    %U - left singular vectors
    for k = 1:rank
        
        u(:,k) = randn(n1,1);
        if k > 1
            u(:,k) = u(:,k) - u(:,1:(k-1))*u(:,1:(k-1))'*u(:,k); 
            %Project u(:,k) onto orthogonal complement of the chosen u
        end
        u(:,k) = renorm(u(:,k));
        
    end
    
    %S
    for k = 1:rank
        
        u(:,k) = u(:,k)*randn(1,1);
        
    end
    
    %V - right singular vectors
    supportUnion = [];
    
    for k = 1:rank
        
        sStructure = zeros(n2,1);
        r = sort(randsample(n2,s));
        sStructure(r) = 1;
        v(:,k) = sprandn(sStructure);
        commonSupport = intersect(supportUnion,find(sStructure));
        if k > 1
            ortho = orth(v(commonSupport,1:(k-1)));
            v(commonSupport,k) = v(commonSupport,k) - ortho*ortho'*v(commonSupport,k);
            %Project v(:,k) onto orthogonal complement of the chosen v
        end
        supportUnion = union(supportUnion,find(sStructure));
        v(:,k) = renorm(v(:,k));
    
    end
        
    d2 = 0;
    
    if nargin > 4
        [d1,d2] = size(singularValues);
    end
        
    if d2 > rank
        rank = d2;
    end
    
    for i = 1:rank
        X = X + u(:,i)*v(:,i)';
    end
    
    [U,S,V] = svd(X);
    sr = randperm(rank,d2);
    s = diag(S);
    
    for i = 1:d2
        s(sr(i)) = singularValues(1,i);
    end
    
    S(1:min(n1,n2),1:min(n1,n2)) = diag(s);
    X = U*S*V';


end

