# Submission Cover Page

## MCP Explorer - Understanding AI Model Context Protocol

### Target Audience
**Primary:** High school students (ages 14-18) with no prior technical background in AI or programming

**Secondary:** High school teachers looking for engaging AI education materials

### Expected Duration
**10-15 minutes** complete interactive experience

### Material Description

MCP Explorer is an interactive web application that demystifies Anthropic's Model Context Protocol (MCP) through storytelling and hands-on experimentation. Students follow a narrative journey with "ARIA," an AI assistant helping a student named "Sam," discovering how MCP transforms AI capabilities.

The experience uses relatable scenarios (study groups, science fair research, scholarship applications) to demonstrate the practical difference between AI assistants with and without MCP. Through interactive toggles and a playground environment, students can experiment with 8 different MCP servers, each providing specific capabilities they can relate to.

Key educational features include:
- Side-by-side comparisons showing WITH vs WITHOUT MCP
- Interactive server toggles for hands-on learning
- Three structured challenge scenarios for assessment
- Real AI integration with live demonstrations
- Knowledge quiz with immediate feedback
- Achievement certificate upon completion

The application includes both a live demo at mcp-explorer.vercel.app and local development capabilities. All technical concepts are explained using everyday language and visual demonstrations, ensuring comprehension without prior coding knowledge.

### Learning Objectives

Upon completion, students will be able to:
1. Explain what MCP (Model Context Protocol) is in their own words
2. Identify the key benefits of using MCP servers with AI assistants
3. Compare AI capabilities with and without MCP through hands-on scenarios
4. Understand how AI assistants connect to external tools and data sources
5. Make strategic decisions about which MCP servers to use for specific tasks
6. Recognize potential MCP applications in their daily academic and personal lives

### Technical Format
- Modern React web application with live AI integration
- Live demo available at: https://mcp-explorer.vercel.app
- Local development supported with comprehensive setup instructions
- Integrates with Anthropic's Claude API for authentic AI experiences
- Responsive design for desktop, tablet, and mobile devices
- Built with accessibility standards (WCAG 2.1 AA compliant)