# MCP Explorer - Interactive Learning Experience

**NeurIPS 2025 Educational Content Submission**

An interactive React web application that teaches high school students about Anthropic's Model Context Protocol (MCP) through narrative-driven learning and hands-on experimentation. This educational resource is designed for the AI Education Resource Showcase.

## 🌐 Try it Live!

**Live Demo**: [https://mcp-explorer.vercel.app](https://mcp-explorer.vercel.app)

Experience the full MCP learning journey immediately - no setup required! The live version includes:
- ✨ **Real AI integration** powered by Anthropic's Claude
- 🔄 **Interactive MCP servers** you can toggle on/off
- 💬 **Live AI chat** that responds based on enabled servers
- 📚 **Complete learning experience** from intro to certificate

## 🎓 Educational Overview

This **10-15 minute interactive learning module** is designed for high school students (ages 14-18) to understand advanced AI concepts through hands-on exploration. 

### Learning Objectives
Students will learn:
- **What is MCP**: Understanding Model Context Protocol as a bridge between AI and external tools
- **Practical Impact**: The difference between AI assistants WITH and WITHOUT MCP capabilities
- **System Architecture**: How different MCP servers provide specialized functionalities
- **Real-world Applications**: Relatable use cases relevant to student life and future careers

### Pedagogical Approach
- **Narrative-driven learning** through a personal AI assistant story
- **Interactive experimentation** with immediate visual feedback
- **Scaffolded progression** from basic concepts to advanced applications
- **Assessment integration** with knowledge quiz and achievement system

## Features

- **Narrative-driven learning** with a personal AI assistant story
- **Interactive server toggles** to experiment with different MCP capabilities
- **Side-by-side comparisons** showing WITH vs WITHOUT MCP scenarios
- **8 MCP servers** with relatable high school use cases
- **Interactive playground** for testing different configurations
- **Live AI chat** with real Anthropic API integration
- **Knowledge quiz** to reinforce learning
- **Achievement certificate** upon completion

## 🚀 Local Development Setup

Want to run this locally or contribute? Follow these steps:

### Prerequisites
- Node.js 16+ 
- An Anthropic API key (for live AI features)

### Installation

1. **Clone and install dependencies:**
```bash
# Repository URL will be provided after review process
git clone [REPOSITORY_URL]
cd neurips-mcp-explorer
npm install
```

2. **Set up your Anthropic API key** (required for live AI chat):
```bash
# Create environment file
cp .env.example .env
```

Edit `.env` and add your API key:
```
ANTHROPIC_API_KEY=your_actual_api_key_here
PORT=5001
```

3. **Get your Anthropic API key:**
   - Visit [console.anthropic.com](https://console.anthropic.com)
   - Create an account or sign in
   - Navigate to **API Keys** and create a new key
   - Copy the key to your `.env` file

   ⚠️ **Important**: Without an API key, the "Try Live" feature will not work.

4. **Start the development servers:**

   **Option A: Full local development (recommended for testing live AI features):**
   ```bash
   npm run start:dev
   ```
   This starts both the React app (port 3000) and Express server (port 5001) concurrently.

   **Option B: Frontend-only development:**
   ```bash
   npm start
   ```
   This only starts the React app. Live AI features may not work without the backend.

5. **Open your browser:**
   - Visit [http://localhost:3000](http://localhost:3000)
   - The app will automatically reload when you make changes
   - Live AI features work with Option A (`npm run start:dev`)

## 🏗️ Building for Production

```bash
npm run build
```

This creates an optimized production build in the `build` folder.

### Deployment Options

**Vercel (Recommended):**
1. Connect your GitHub repo to Vercel
2. Add your `ANTHROPIC_API_KEY` to Vercel's environment variables
3. Deploy automatically on every push

**Other Platforms:**
- Any static hosting service (Netlify, GitHub Pages, etc.)
- For full AI functionality, ensure serverless functions support

## 📖 How It Works

The app provides both **real AI integration** and **intelligent simulation**:

- **With Anthropic API key**: Uses real Claude AI for responses
- **Without API key**: Falls back to client-side MCP simulation
- **Seamless experience**: Users get educational value either way

This ensures the learning experience works for everyone, whether they have API access or not.

## 👥 Target Audience & Prerequisites

**Primary Audience**: High school students (ages 14-18)
- No prior technical background required
- Basic familiarity with AI assistants (ChatGPT, etc.) helpful but not necessary
- Designed for visual and interactive learners

**Secondary Audiences**: 
- Educators teaching AI concepts
- Undergraduate students in computer science
- General audience interested in AI system architecture

## 📚 Learning Journey & Curriculum Integration

### Module Structure (15 minutes total)
1. **Introduction (2 min)** - Problem identification through storytelling
2. **Technical Overview (3 min)** - System architecture and components  
3. **Discovery (3 min)** - Comparative analysis WITH vs WITHOUT MCP
4. **Hands-on Exploration (5 min)** - Interactive server configuration
5. **Try Live (2 min)** - Real AI interaction with MCP
6. **Assessment (1 min)** - Knowledge validation and certification

### Curriculum Connections
- **Computer Science**: System architecture, APIs, software integration
- **Information Technology**: Client-server models, protocols, data flow
- **Digital Literacy**: Understanding AI capabilities and limitations
- **Critical Thinking**: Evaluating technology trade-offs and applications

## 🛠️ Technical Stack

- **Frontend**: React 18 with Tailwind CSS
- **Animations**: Framer Motion for smooth interactions
- **State Management**: Zustand for simple, effective state management
- **AI Integration**: Anthropic Claude API via serverless functions
- **Icons**: Lucide React for consistent iconography
- **Deployment**: Vercel with automatic deployments

## 🌏 Browser Compatibility

- Chrome (latest 2 versions)
- Safari (latest 2 versions)
- Firefox (latest 2 versions)
- Edge (latest 2 versions)

## ♿ Accessibility

- WCAG 2.1 AA compliant
- Full keyboard navigation support
- Screen reader compatible
- High contrast ratios
- Scalable fonts and responsive design

## 🤝 Contributing

Want to improve the MCP Explorer? Contributions are welcome!

1. Fork the repository
2. Create a feature branch
3. Make your changes
4. Submit a pull request

## 📊 Educational Impact & Assessment

### Learning Outcomes Assessment
- **Pre/Post Concept Understanding**: Integrated quiz system measures knowledge gain
- **Engagement Metrics**: Interactive completion tracking and time-on-task analysis  
- **Skill Application**: Hands-on server configuration demonstrates practical understanding
- **Achievement Recognition**: Completion certificates motivate learning progression

### Accessibility & Inclusion
- **Universal Design**: WCAG 2.1 AA compliant for diverse learners
- **Multiple Learning Styles**: Visual, auditory, and kinesthetic engagement
- **Language Considerations**: Age-appropriate vocabulary with technical term scaffolding
- **Technology Access**: Works on standard school devices and low-bandwidth connections

## 📄 License & Attribution

This educational resource is submitted to **NeurIPS 2025 Call For Education Materials** for the AI Education Resource Showcase.

**Open Source License**: MIT License - free for educational use and adaptation.

## 🔗 Resources & Links

### Primary Resources
- **Live Demo**: [mcp-explorer.vercel.app](https://mcp-explorer.vercel.app)

### Background Reading
- **MCP Documentation**: [modelcontextprotocol.io](https://modelcontextprotocol.io)
- **Anthropic Research**: Understanding AI system architecture and capabilities
- **Educational Technology**: Interactive learning design for STEM education

### For Educators
- **Implementation Guide**: Detailed setup instructions included
- **Learning Extensions**: Suggestions for deeper technical exploration
- **Assessment Rubrics**: Built-in quiz system with extensible question bank
