import React from 'react';

const EnhancedAIResponse = ({ text, functionsUsed = [] }) => {
  console.log('EnhancedAIResponse:', { text, functionsUsed }); // Debug logging

  const highlightFunctions = (text) => {
    if (!functionsUsed || functionsUsed.length === 0) {
      return formatText(text);
    }

    let highlightedText = text;
    
    // Create a regex pattern for all functions
    functionsUsed.forEach(func => {
      const escapedFunc = func.replace(/[()]/g, '\\$&');
      const regex = new RegExp(`\\b${escapedFunc}\\b`, 'gi');
      highlightedText = highlightedText.replace(regex, `<span style="background-color: #fef3c7; color: #92400e; padding: 2px 6px; border-radius: 4px; font-family: Monaco, Menlo, monospace; font-size: 0.9em; font-weight: 600; border: 1px solid #f59e0b;">${func}</span>`);
    });

    return formatText(highlightedText);
  };

  const formatText = (text) => {
    // Handle inline *text* formatting by converting to <em> tags
    let formattedText = text.replace(/\*([^*]+)\*/g, '<em class="text-gray-600 italic">$1</em>');
    
    // Split text into paragraphs and format
    const paragraphs = formattedText.split('\n');
    
    return paragraphs.map((paragraph, index) => {
      if (paragraph.trim() === '') {
        // Empty line
        return <div key={index} className="mb-2"></div>;
      } else {
        // Regular paragraphs with function highlighting and inline formatting
        return (
          <div key={index} className="mb-2 text-sm" dangerouslySetInnerHTML={{ __html: paragraph }} />
        );
      }
    });
  };

  return (
    <div className="leading-relaxed">
      {highlightFunctions(text)}
    </div>
  );
};

export default EnhancedAIResponse;