import React from 'react';

const MarkdownText = ({ text, className = "" }) => {
  const renderText = (text) => {
    if (!text) return text;
    
    // Split by lines first to handle line breaks
    const lines = text.split('\n');
    
    return lines.map((line, lineIndex) => {
      // Handle bold text **text**
      let processedLine = line.replace(/\*\*(.*?)\*\*/g, '<strong>$1</strong>');
      
      // Handle bullet points • at start of line
      const isBulletPoint = processedLine.trim().startsWith('•');
      
      return (
        <span key={lineIndex}>
          {isBulletPoint ? (
            <span className="block leading-tight mb-1" dangerouslySetInnerHTML={{ __html: processedLine }} />
          ) : (
            <span dangerouslySetInnerHTML={{ __html: processedLine }} />
          )}
          {lineIndex < lines.length - 1 && !isBulletPoint && <br />}
        </span>
      );
    });
  };

  return (
    <div className={className}>
      {renderText(text)}
    </div>
  );
};

export default MarkdownText;