import React from 'react';
import { motion } from 'framer-motion';

const ProgressBar = ({ steps, currentStep, onStepClick }) => {
  const progress = ((currentStep + 1) / steps.length) * 100;

  return (
    <div className="bg-white shadow-sm px-6 py-4 sticky top-0 z-40">
      <div className="max-w-4xl mx-auto">
        <div className="flex justify-between items-center mb-2">
          <h3 className="text-sm font-medium text-gray-600">Your Learning Journey</h3>
          <span className="text-sm text-gray-500">{Math.round(progress)}% Complete</span>
        </div>
        
        <div className="relative">
          <div className="h-2 bg-gray-200 rounded-full overflow-hidden">
            <motion.div
              className="h-full bg-gradient-to-r from-primary to-secondary rounded-full"
              initial={{ width: 0 }}
              animate={{ width: `${progress}%` }}
              transition={{ duration: 0.5, ease: "easeOut" }}
            />
          </div>
          
          <div className="flex justify-between mt-2">
            {steps.map((step, index) => (
              <button
                key={step.id}
                onClick={() => onStepClick && onStepClick(index)}
                className={`text-xs transition-colors ${
                  index <= currentStep ? 'text-primary font-medium' : 'text-gray-400'
                } ${
                  index !== currentStep ? 'hover:text-secondary cursor-pointer' : 'cursor-default'
                }`}
              >
                {step.name}
              </button>
            ))}
          </div>
        </div>
      </div>
    </div>
  );
};

export default ProgressBar;