import React from 'react';
import { motion } from 'framer-motion';
import { Code } from 'lucide-react';
import { getServerFunctionCount } from '../utils/serverFunctions';

const ServerCard = ({ server, isEnabled, onToggle, onClick }) => {
  const Icon = server.icon;

  return (
    <motion.div
      whileHover={{ y: -4 }}
      className={`server-card bg-white rounded-xl shadow-lg p-6 relative h-full flex flex-col border-2 ${
        isEnabled ? 'border-primary' : 'border-transparent'
      }`}
    >
      <div className="absolute top-4 right-4">
        <button
          onClick={(e) => {
            e.stopPropagation();
            onToggle();
          }}
          className={`w-12 h-6 rounded-full transition-colors relative ${
            isEnabled ? 'bg-primary' : 'bg-gray-300'
          }`}
        >
          <motion.div
            animate={{ x: isEnabled ? 24 : 0 }}
            transition={{ type: "spring", stiffness: 500, damping: 30 }}
            className="absolute top-1 left-1 w-4 h-4 bg-white rounded-full shadow-md"
          />
        </button>
      </div>

      <div className={`inline-flex items-center justify-center w-14 h-14 ${server.color} ${isEnabled ? 'bg-opacity-10' : 'bg-opacity-5'} rounded-xl mb-4`}>
        <Icon className={`w-7 h-7 ${server.color.replace('bg-', 'text-').replace('500', '700')} ${!isEnabled ? 'opacity-20' : ''}`} />
      </div>

      <h3 className="font-semibold text-gray-800 mb-2">
        {server.name}
      </h3>

      <p className="text-sm text-gray-600 mb-3 flex-grow">
        {server.description}
      </p>

      <div className="flex items-center justify-between mt-auto pt-4 border-t">
        <div className="flex items-center">
          <Code className="w-3 h-3 text-gray-400 mr-1" />
          <span className="text-xs text-gray-400">
            {getServerFunctionCount(server.id)} functions
          </span>
        </div>
        <button 
          onClick={onClick}
          className="text-xs text-gray-400 hover:text-gray-600 underline transition-colors"
        >
          View Details
        </button>
      </div>
    </motion.div>
  );
};

export default ServerCard;