import { 
  Calendar, 
  Cloud, 
  Map, 
  Music, 
  Newspaper, 
  Languages, 
  Calculator, 
  BookOpen 
} from 'lucide-react';

export const mcpServers = [
  {
    id: 'calendar',
    name: 'Study Scheduler',
    icon: Calendar,
    description: 'Helps coordinate group study sessions and track assignment deadlines',
    useCase: 'Managing student schedules',
    color: 'bg-blue-500',
    examples: {
      without: {
        query: "When can my study group meet this week before the chemistry test?",
        response: "I don't have access to your calendars. You'll need to check with each person individually about their availability."
      },
      with: {
        query: "When can my study group meet this week before the chemistry test?",
        response: "Perfect timing! Your study group is all free:\n• Tuesday 4-6pm (School library available)\n• Thursday 7-9pm (Emma's house works)\n• Saturday 2-5pm (Most focused time for everyone)\n\nChemistry test is Friday - I recommend Thursday for final review!"
      }
    },
    playground: {
      question: "When are you and your lab partner free to work on the science project?",
      answer: "Great question! I found these perfect times for your science project:\n• Tomorrow 3:30-5:30pm (School lab is available)\n• Thursday 4-6pm (Both free after soccer practice)\n• Saturday 10am-1pm (Weekend focus time)\n\nThe project's due Monday, so I'd suggest booking the lab tomorrow to get hands-on work done!",
      sampleQuestions: [
        "When can my study group meet this week?",
        "Book the library study room for tomorrow at 4pm",
        "What time is my chemistry test next week?",
        "Schedule a group meeting for our history project"
      ]
    }
  },
  {
    id: 'weather',
    name: 'Activity Planner',
    icon: Cloud,
    description: 'Helps plan outdoor activities, sports practice, and school events',
    useCase: 'Planning school activities',
    color: 'bg-cyan-500',
    examples: {
      without: {
        query: "Should we move Friday's pep rally indoors or keep it at the football field?",
        response: "I can't check the weather forecast. You should check a weather app or website to decide."
      },
      with: {
        query: "Should we move Friday's pep rally indoors or keep it at the football field?",
        response: "Friday looks perfect for outdoor pep rally! 68°F with sunny skies and light winds. No rain expected until Sunday. The football field will be ideal - students won't need jackets!"
      }
    },
    playground: {
      question: "Is it good weather for our class photo shoot tomorrow?",
      answer: "Excellent timing for your class photos! 🌞\n• Temperature: 72°F (perfect for outdoor shots)\n• Sunny with light clouds (natural lighting is ideal)\n• Light breeze (hair will look great, not messy)\n• 0% chance of rain\n\nThe golden hour lighting around 4-5pm will make everyone look amazing!",
      sampleQuestions: [
        "Should we move the pep rally indoors or keep it outside?",
        "Is it good weather for our class photo shoot tomorrow?",
        "Will it rain during lunch break today?",
        "What's the temperature for our outdoor biology lab?"
      ]
    }
  },
  {
    id: 'maps',
    name: 'Campus Navigator',
    icon: Map,
    description: 'Helps find the best routes around school and town for student activities',
    useCase: 'Getting around efficiently',
    color: 'bg-green-500',
    examples: {
      without: {
        query: "What's the quickest way to get from chemistry lab to the cafeteria before lunch ends?",
        response: "I can't access maps or building layouts. You'll need to figure out the route yourself."
      },
      with: {
        query: "What's the quickest way to get from chemistry lab to the cafeteria before lunch ends?",
        response: "Quick route found! 2 minutes via the main hallway:\n• Exit chem lab, turn left\n• Take the central staircase down\n• Cafeteria entrance is 50 feet ahead\n\nYou've got 8 minutes left in lunch period - perfect timing!"
      }
    },
    playground: {
      question: "How do I get from school to the new study café downtown?",
      answer: "Perfect study spot choice! Here's the best route to Grind Coffee & Study:\n• 12-minute walk via Elm Street (safest route)\n• Bus #15 takes 6 minutes (runs every 15 min)\n• Your friend Maya is already there studying for AP History! ☕\n\nThey have those comfy study booths you love, and WiFi is strong on the second floor!",
      sampleQuestions: [
        "How do I get from school to the new study café downtown?",
        "What's the quickest way from chemistry lab to the cafeteria?",
        "Show me the safest route to walk home after dark",
        "Where's the nearest coffee shop from the library?"
      ]
    }
  },
  {
    id: 'music',
    name: 'Study Beats',
    icon: Music,
    description: 'Creates perfect playlists for studying, homework, and focus sessions',
    useCase: 'Study atmosphere',
    color: 'bg-purple-500',
    examples: {
      without: {
        query: "I need music to help me focus while writing my English essay",
        response: "I can't create or access playlists. You could try searching for study music on your streaming app."
      },
      with: {
        query: "I need music to help me focus while writing my English essay",
        response: "Perfect! Created 'Essay Writing Focus' playlist:\n• Ambient instrumental tracks\n• Lo-fi hip hop beats\n• Light classical piano\n• No lyrics to distract from writing\n\nEstimated study time: 2 hours. Now playing on your Spotify!"
      }
    },
    playground: {
      question: "Make me a playlist for cramming before tomorrow's biology test",
      answer: "Created 'Bio Cram Session' - 90 minutes of perfect study energy! 🧠\n• Brain-boosting instrumental beats\n• Nature sounds (helps with biology concepts!)\n• Motivational lo-fi tracks\n• Memory-enhancing alpha wave frequencies\n\nStarting with 'Focus Flow' - your brain's about to absorb everything! 📚✨",
      sampleQuestions: [
        "Make me a playlist for cramming before tomorrow's biology test",
        "I need focus music for writing my English essay",
        "Create upbeat music for our group study session",
        "What's good background music for math homework?"
      ]
    }
  },
  {
    id: 'news',
    name: 'Research Helper',
    icon: Newspaper,
    description: 'Finds current articles and reliable sources for school projects',
    useCase: 'Academic research',
    color: 'bg-red-500',
    examples: {
      without: {
        query: "I need current info about climate change for my environmental science project",
        response: "I don't have access to recent news or current data. Try searching on news websites or your school's database."
      },
      with: {
        query: "I need current info about climate change for my environmental science project",
        response: "Found 6 recent articles from credible sources:\n• 'Youth Climate Activists Make Impact' - National Geographic\n• 'New Green Technology in Schools' - Science News\n• 'Climate Data Shows 2024 Trends' - EPA Report\n\nAll sources are .edu or established news - perfect for citing in your bibliography!"
      }
    },
    playground: {
      question: "What's the latest on AI in education for my tech presentation?",
      answer: "Great topic choice! Found fresh articles for your presentation: 🤖📚\n• 'AI Tutors Help Students Learn Faster' - Education Week\n• 'High School Coding with AI Tools' - MIT Technology Review\n• 'Student Uses AI for Science Fair Win' - Local News\n\nPlus I found 3 case studies from schools using AI - these will make your presentation stand out!",
      sampleQuestions: [
        "What's the latest on AI in education for my tech presentation?",
        "Find current articles about climate change for my science project",
        "I need recent news about renewable energy for my essay",
        "What are the latest developments in space exploration?"
      ]
    }
  },
  {
    id: 'translation',
    name: 'Language Tutor',
    icon: Languages,
    description: 'Helps perfect your foreign language homework and pronunciation',
    useCase: 'World language classes',
    color: 'bg-indigo-500',
    examples: {
      without: {
        query: "Check my Spanish presentation script and help with pronunciation",
        response: "I can help with basic translations but can't provide audio pronunciation or detailed grammar feedback."
      },
      with: {
        query: "Check my Spanish presentation script and help with pronunciation",
        response: "¡Excelente! Your script looks great with 2 minor fixes:\n• 'estudiantes' needs accent: 'estudiántes'\n• 'muy buena' → 'muy bueno' (matches gender)\n\nPronunciation guide attached + audio clips for tricky words. You'll nail this presentation! 🇪🇸"
      }
    },
    playground: {
      question: "How do I ask my exchange student friend about weekend plans in German?",
      answer: "'Was hast du am Wochenende vor?' 🇩🇪\n\nPronunciation: 'Vas hast doo am VOH-khen-en-deh for?'\n\nCasual alternative: 'Was machst du am Wochenende?' (What are you doing this weekend?)\n\nYour friend will be so impressed you're practicing! Germans love when people try to speak their language.",
      sampleQuestions: [
        "How do I ask my exchange student friend about weekend plans in German?",
        "Help me practice my Spanish presentation script",
        "Translate this French homework into English",
        "Check my pronunciation for these Italian words"
      ]
    }
  },
  {
    id: 'calculator',
    name: 'Math Solver',
    icon: Calculator,
    description: 'Solves complex homework problems with step-by-step explanations',
    useCase: 'Mathematics homework',
    color: 'bg-yellow-500',
    examples: {
      without: {
        query: "Help me solve this quadratic equation and show all the work for my algebra test",
        response: "I can explain the general process but might make computational errors in the specific calculations."
      },
      with: {
        query: "Help me solve this quadratic equation and show all the work for my algebra test",
        response: "Let's solve x² + 5x - 6 = 0 step by step:\n1. Factor: (x + 6)(x - 1) = 0\n2. Set each factor = 0: x + 6 = 0 OR x - 1 = 0\n3. Solutions: x = -6 OR x = 1\n\n✓ Check: Both solutions work! Graph shows perfect parabola."
      }
    },
    playground: {
      question: "How much should each person pay if 4 friends split a $52.80 dinner bill with 18% tip?",
      answer: "Let's break down your group dinner bill! 🍕\n\nBill calculation:\n• Food: $52.80\n• 18% tip: $9.50\n• Total: $62.30\n\nPer person: $15.58 each\n\nPro tip: Venmo $15.60 each to make it easy - that covers tax variations too! 💳",
      sampleQuestions: [
        "How much should each person pay if 4 friends split a $52.80 dinner bill with 18% tip?",
        "Solve this quadratic equation: x² + 5x - 6 = 0",
        "What's 15% of 240?",
        "Help me calculate the area of a circle with radius 7cm"
      ]
    }
  },
  {
    id: 'wikipedia',
    name: 'Fact Checker',
    icon: BookOpen,
    description: 'Instantly verifies information and finds reliable sources for essays',
    useCase: 'Research verification',
    color: 'bg-teal-500',
    examples: {
      without: {
        query: "Is it true that the Great Wall of China is visible from space? I need this for my history report.",
        response: "I believe that's actually a myth based on my training, but I can't verify with current sources or find citations for you."
      },
      with: {
        query: "Is it true that the Great Wall of China is visible from space? I need this for my history report.",
        response: "✓ MYTH BUSTED! Verified from NASA and multiple sources:\n• Not visible from space without aid\n• Astronauts confirm this is false\n• Urban legend started in 1938\n\nFound 4 credible sources you can cite in your bibliography! Your teacher will love the fact-checking. 🏰"
      }
    },
    playground: {
      question: "Do we really only use 10% of our brains?",
      answer: "✓ Another myth debunked! Here's what science actually shows:\n\nThe Truth: We use virtually 100% of our brain\n• Brain scans show activity throughout\n• Even simple tasks use multiple regions\n• Myth started from misquoted 1890s research\n\nFun fact: Your brain uses 20% of your body's energy despite being only 2% of your weight! 🧠⚡",
      sampleQuestions: [
        "Do we really only use 10% of our brains?",
        "Is the Great Wall of China visible from space?",
        "How many chambers does a human heart have?",
        "What causes the northern lights?"
      ]
    }
  },
];

export default mcpServers;