import React from "react";
import { motion } from "framer-motion";
import { ArrowLeft, ArrowRight, User, Zap, Target } from "lucide-react";
import useProgress from "../hooks/useProgress";

const ChallengeIntro = () => {
  const { nextStep, previousStep } = useProgress();

  return (
    <div className='max-w-4xl mx-auto'>
      <motion.div
        initial={{ opacity: 0, y: 20 }}
        animate={{ opacity: 1, y: 0 }}
        className='text-center mb-12'
      >
        <div className='inline-flex items-center justify-center w-16 h-16 bg-gradient-to-r from-primary to-secondary rounded-full mb-6'>
          <Target className='w-8 h-8 text-white' />
        </div>

        <h2 className='text-4xl font-bold text-gray-800 mb-6'>
          Ready for a Challenge?
        </h2>
        <p className='text-xl text-gray-600 mb-8 max-w-2xl mx-auto'>
          Now that you've experienced MCP firsthand, let's put your
          understanding to the test with a real-world scenario.
        </p>
      </motion.div>

      <motion.div
        initial={{ opacity: 0, y: 30 }}
        animate={{ opacity: 1, y: 0 }}
        transition={{ delay: 0.2 }}
        className='bg-gradient-to-r from-blue-50 to-purple-50 rounded-2xl p-8 mb-8'
      >
        <div className='flex items-start space-x-4 mb-6'>
          <div className='flex-shrink-0'>
            <div className='w-12 h-12 bg-primary rounded-full flex items-center justify-center'>
              <User className='w-6 h-6 text-white' />
            </div>
          </div>
          <div>
            <h3 className='text-xl font-semibold text-gray-800 mb-2'>
              Meet Sam
            </h3>
            <p className='text-gray-600 mb-4'>
              Sam is a busy high school student juggling academics,
              extracurriculars, and social life. They need an AI assistant that
              can truly understand and help with their complex, multi-faceted
              needs.
            </p>
          </div>
        </div>

        <div className='bg-white rounded-xl p-6 border-l-4 border-primary'>
          <h4 className='font-semibold text-gray-800 mb-3 flex items-center'>
            <Zap className='w-5 h-5 text-primary mr-2' />
            Sam's Situation
          </h4>
          <p className='text-gray-700 mb-4'>
            "I have a huge history presentation due next week, and I need to
            coordinate with my study group, find reliable sources, and somehow
            fit it around my soccer practice schedule. Plus, I want to create
            some background music for the presentation. Can AI really help me
            with all of this?"
          </p>
          <div className='bg-gray-50 rounded-lg p-4'>
            <p className='text-sm text-gray-600 italic'>
              This is exactly the kind of complex, multi-domain challenge where
              MCP shines. Without it, AI would struggle to provide comprehensive
              help across all these different areas.
            </p>
          </div>
        </div>
      </motion.div>

      <motion.div
        initial={{ opacity: 0, y: 30 }}
        animate={{ opacity: 1, y: 0 }}
        transition={{ delay: 0.4 }}
        className='text-center mb-8'
      >
        <h3 className='text-2xl font-semibold text-gray-800 mb-4'>
          Your Challenge
        </h3>
        <p className='text-lg text-gray-600 max-w-3xl mx-auto'>
          Help Sam by choosing the right combination of MCP servers. You'll need
          to think about which servers can work together to address Sam's
          multi-faceted request effectively.
        </p>
      </motion.div>

      {/* Navigation */}
      <div className='flex justify-between items-center'>
        <button
          onClick={previousStep}
          className='inline-flex items-center px-6 py-3 text-gray-600 bg-gray-100 rounded-full hover:bg-gray-200 transition-colors'
        >
          <ArrowLeft className='mr-2 w-4 h-4' />
          Back to Try Live
        </button>

        <button
          onClick={nextStep}
          className='inline-flex items-center px-6 py-3 bg-gradient-to-r from-primary to-secondary text-white font-medium rounded-full hover:shadow-lg transition-shadow'
        >
          Take the Challenge
          <ArrowRight className='ml-2 w-4 h-4' />
        </button>
      </div>
    </div>
  );
};

export default ChallengeIntro;
