import React from "react";
import { motion } from "framer-motion";
import {
  ArrowRight,
  Trophy,
  Heart,
  Sparkles,
  CheckCircle,
  Brain,
} from "lucide-react";
import useProgress from "../hooks/useProgress";

const Congratulations = ({ nextStep: customNextStep }) => {
  const { nextStep: defaultNextStep, userName } = useProgress();
  const nextStep = customNextStep || defaultNextStep;

  const achievements = [
    {
      icon: Brain,
      title: "MCP Mastery",
      description:
        "You understand how MCP transforms basic AI into powerful assistants",
    },
    {
      icon: CheckCircle,
      title: "Problem Solver",
      description:
        "You successfully helped Sam through science fair, college visits, and scholarship applications",
    },
    {
      icon: Sparkles,
      title: "ARIA Builder",
      description:
        "You configured the perfect MCP servers to meet Sam's academic needs",
    },
  ];

  return (
    <div className='max-w-4xl mx-auto'>
      <motion.div
        initial={{ opacity: 0, scale: 0.9 }}
        animate={{ opacity: 1, scale: 1 }}
        transition={{ duration: 0.5 }}
        className='text-center mb-10'
      >
        <div className='inline-flex items-center justify-center w-24 h-24 bg-gradient-to-br from-green-400 to-emerald-600 rounded-full mb-6'>
          <Trophy className='w-12 h-12 text-white' />
        </div>

        <h1 className='text-4xl font-bold text-gray-800 mb-4'>
          Amazing Work, {userName.split(" ")[0]}!
        </h1>

        <p className='text-xl text-gray-600'>
          Thank you for helping Sam build the perfect AI assistant
        </p>
      </motion.div>

      <motion.div
        initial={{ opacity: 0, y: 20 }}
        animate={{ opacity: 1, y: 0 }}
        transition={{ duration: 0.5, delay: 0.2 }}
        className='bg-white rounded-2xl shadow-xl p-8 mb-8'
      >
        <div className='flex items-start mb-6'>
          <div className='flex-shrink-0 w-12 h-12 bg-green-100 rounded-full flex items-center justify-center mr-4'>
            <Heart className='w-6 h-6 text-green-600' />
          </div>
          <div>
            <h2 className='text-2xl font-semibold text-gray-800 mb-3'>
              Sam's Success Story
            </h2>
            <div className='space-y-4 text-gray-600'>
              <p className='leading-relaxed'>
                Thanks to your brilliant work configuring ARIA with MCP servers,
                Sam is now thriving academically! The science fair presentation
                was a huge success with current, verified research. The college
                visits were perfectly coordinated with family schedules and
                weather planning.
              </p>
              <p className='leading-relaxed'>
                Most importantly, Sam's international scholarship application
                was flawless - with perfect Spanish translation, solved calculus
                problems, and accurate financial calculations. Sam is well on
                the way to studying abroad in Madrid!
              </p>
            </div>
          </div>
        </div>

        <div className='bg-gradient-to-r from-green-50 to-emerald-50 rounded-lg p-6'>
          <h3 className='font-semibold text-green-800 mb-4'>
            Your Learning Progress:
          </h3>
          <div className='grid md:grid-cols-3 gap-4'>
            {achievements.map((achievement, index) => {
              const Icon = achievement.icon;
              return (
                <motion.div
                  key={index}
                  initial={{ opacity: 0, y: 10 }}
                  animate={{ opacity: 1, y: 0 }}
                  transition={{ duration: 0.3, delay: 0.4 + index * 0.1 }}
                  className='bg-white rounded-lg p-4 text-center'
                >
                  <Icon className='w-8 h-8 text-green-600 mx-auto mb-2' />
                  <h4 className='font-semibold text-gray-800 text-sm mb-1'>
                    {achievement.title}
                  </h4>
                  <p className='text-xs text-gray-600 leading-relaxed'>
                    {achievement.description}
                  </p>
                </motion.div>
              );
            })}
          </div>
        </div>
      </motion.div>

      <motion.div
        initial={{ opacity: 0, y: 20 }}
        animate={{ opacity: 1, y: 0 }}
        transition={{ duration: 0.5, delay: 0.6 }}
        className='bg-gradient-to-r from-primary/5 to-secondary/5 rounded-2xl p-6 mb-8'
      >
        <div className='text-center'>
          <Sparkles className='w-8 h-8 text-primary mx-auto mb-3' />
          <h3 className='text-xl font-semibold text-gray-800 mb-2'>
            Ready for the Final Challenge?
          </h3>
          <p className='text-gray-600 mb-4'>
            Now let's test how much you've learned about MCP! Take our quick
            quiz to show off your new expertise and earn your official MCP
            Explorer certificate.
          </p>
          <div className='inline-flex items-center text-sm text-gray-500 bg-white px-3 py-1 rounded-full'>
            ⏱ Quiz takes about 2-3 minutes
          </div>
        </div>
      </motion.div>

      <motion.div
        initial={{ opacity: 0 }}
        animate={{ opacity: 1 }}
        transition={{ duration: 0.5, delay: 0.8 }}
        className='text-center'
      >
        <button
          onClick={nextStep}
          className='inline-flex items-center px-8 py-4 bg-gradient-to-r from-primary to-secondary text-white font-semibold rounded-full shadow-lg hover:shadow-xl transform hover:-translate-y-1 transition-all duration-200'
        >
          Take the MCP Quiz
          <ArrowRight className='ml-2 w-5 h-5' />
        </button>

        <p className='text-sm text-gray-500 mt-4'>
          🏆 Earn your MCP Explorer certificate upon completion
        </p>
      </motion.div>
    </div>
  );
};

export default Congratulations;
