import React, { useState } from "react";
import { motion } from "framer-motion";
import { Bot, ArrowRight, Sparkles } from "lucide-react";
import useProgress from "../hooks/useProgress";

const Introduction = () => {
  const { nextStep, userName } = useProgress();
  const [showContent, setShowContent] = useState(false);

  React.useEffect(() => {
    setTimeout(() => setShowContent(true), 500);
  }, []);

  return (
    <div className='max-w-4xl mx-auto'>
      <motion.div
        initial={{ opacity: 0 }}
        animate={{ opacity: 1 }}
        transition={{ duration: 0.3 }}
        className='text-center mb-12'
      >
        <div className='inline-flex items-center justify-center w-24 h-24 bg-gradient-to-br from-primary to-secondary rounded-full mb-6'>
          <Bot className='w-12 h-12 text-white' />
        </div>

        <h1 className='text-4xl font-bold text-gray-800 mb-4'>
          Help Build ARIA for Sam
        </h1>

        <p className='text-xl text-gray-600'>
          Sam needs a smarter AI assistant. Can you help build one?
        </p>
      </motion.div>

      {showContent && (
        <motion.div
          initial={{ opacity: 0 }}
          animate={{ opacity: 1 }}
          transition={{ duration: 0.3 }}
          className='bg-white rounded-2xl shadow-xl p-8 mb-8'
        >
          <div className='flex items-start mb-6'>
            <div className='flex-shrink-0 w-12 h-12 bg-primary/10 rounded-full flex items-center justify-center mr-4'>
              <Sparkles className='w-6 h-6 text-primary' />
            </div>
            <div>
              <h2 className='text-2xl font-semibold text-gray-800 mb-3'>
                Meet Sam: A High School Student Who Needs Help
              </h2>
              <p className='text-gray-600 leading-relaxed mb-4'>
                Hey {userName.split(" ")[0]}! Meet Sam, a junior at Westfield
                High who's feeling overwhelmed. Sam has a science fair
                presentation tomorrow, college visits to coordinate, and a
                scholarship application due soon. When Sam asks ARIA for help,
                she says "I can't access current news" or "I don't have your
                calendar." Not very helpful!
              </p>
              <p className='text-gray-600 leading-relaxed mb-4'>
                Your mission: Help build a smarter ARIA that can actually help
                Sam succeed! You'll learn about
                <span className='font-semibold text-primary'>
                  {" "}
                  MCP (Model Context Protocol)
                </span>{" "}
                - the technology that transforms basic AI into a truly helpful
                assistant.
              </p>
              <div className='bg-blue-50 border-l-4 border-primary p-4 rounded-lg'>
                <p className='text-gray-700'>
                  <strong>Think of it like this:</strong> You're helping ARIA
                  evolve from a basic chatbot into Sam's personal academic
                  assistant. By the end, you'll see ARIA help Sam with real
                  challenges!
                </p>
              </div>
            </div>
          </div>

          <div className='grid md:grid-cols-2 gap-6 mt-8'>
            <div className='bg-red-50 rounded-lg p-6'>
              <h3 className='font-semibold text-red-700 mb-2'>
                😔 ARIA Can't Help Sam Yet
              </h3>
              <ul className='text-sm text-gray-600 space-y-2'>
                <li>• "I can't find current articles for your science fair"</li>
                <li>• "I don't have access to your family's schedules"</li>
                <li>• "I can't help coordinate your college visits"</li>
                <li>• "I don't know when your assignments are due"</li>
              </ul>
            </div>

            <div className='bg-green-50 rounded-lg p-6'>
              <h3 className='font-semibold text-green-700 mb-2'>
                🎯 ARIA Will Help Sam With
              </h3>
              <ul className='text-sm text-gray-600 space-y-2'>
                <li>
                  • "Found 5 recent articles for your renewable energy project!"
                </li>
                <li>
                  • "Your family is free Saturday 2-4pm for college visits"
                </li>
                <li>• "Weather looks perfect for the outdoor campus tour"</li>
                <li>
                  • "Your scholarship essay translated perfectly to Spanish!"
                </li>
              </ul>
            </div>
          </div>
        </motion.div>
      )}

      {showContent && (
        <motion.div
          initial={{ opacity: 0 }}
          animate={{ opacity: 1 }}
          transition={{ duration: 0.3, delay: 0.2 }}
          className='text-center'
        >
          <button
            onClick={nextStep}
            className='inline-flex items-center px-8 py-4 bg-gradient-to-r from-primary to-secondary text-white font-semibold rounded-full shadow-lg hover:shadow-xl transform hover:-translate-y-1 transition-all duration-200'
          >
            Start Building ARIA for Sam
            <ArrowRight className='ml-2 w-5 h-5' />
          </button>

          <p className='text-sm text-gray-500 mt-4'>
            ⏱ This experience takes about 10-15 minutes
          </p>
        </motion.div>
      )}
    </div>
  );
};

export default Introduction;
