# Region-Aware Reconstruction Strategy for fMRI Foundation Model Pretraining

This repository contains the official implementation of our NeurIPS 2025 Workshop paper:  
**"Region-Aware Reconstruction Strategy for fMRI Foundation Model Pretraining."**

> **Acknowledgment**: This codebase is built upon and extends the [NeuroSTORM repository](https://github.com/CUHK-AIM-Group/NeuroSTORM). We gratefully acknowledge their contribution and infrastructure, which served as the foundation for this work.

---

## Setup

Clone the repository and install dependencies:

```bash

cd NeuroSTORM
conda create -n neurostorm python=3.10 -y
conda activate neurostorm

source ./set_env.sh

pip install torch==2.1.0 torchvision==0.16.0 torchaudio==2.1.0 --index-url https://download.pytorch.org/whl/cu118
pip install tensorboard tensorboardX tqdm ipdb nvitop monai==1.3.0
pip install pytorch-lightning==1.9.4 neptune nibabel nilearn numpy==1.22.4
pip install https://github.com/Dao-AILab/causal-conv1d/releases/download/v1.5.0.post8/causal_conv1d-1.5.0.post8+cu11torch2.1cxx11abiTRUE-cp310-cp310-linux_x86_64.whl
pip install https://github.com/state-spaces/mamba/releases/download/v2.2.2/mamba_ssm-2.2.2+cu118torch2.1cxx11abiFALSE-cp310-cp310-linux_x86_64.whl


### Requirements

* Python 3.9+
* PyTorch 2.1+
* CUDA 11.8+
* nibabel, nilearn, scikit-learn, numpy, pandas, matplotlib


### Dataset Preprocessing
cd NeuroSTORM/datasets
python preprocessing_volume.py --dataset_name adhd200 --load_root ./data/adhd200 --save_root ./processed_data/adhd200 --num_processes 8

```

## Dataset

We use the [ADHD-200 dataset](http://fcon_1000.projects.nitrc.org/indi/adhd200/) (973 subjects).
Preprocessing steps:

* Registration to MNI152 template
* Resampling to 2mm isotropic voxels
* Cropping/padding to 96 × 96 × 96
* Temporal normalization (TR = 0.8s)
* Z-scoring across non-background voxels

Please download the dataset manually and update `--data-dir <path_to_adhd200>` when running experiments.

---

## Training

To pretrain the model with ROI-guided masking:

```bash
bash scripts/adhd200_pretrain/pt_neurostorm_task3_atlas_tube.sh
```
For example, to mask the limbic and frontal regions:

```bash
python main.py \
  ....
  --spatial_mask atlas \
  --time_mask tube \
  --region_of_interest limbic,frontal \
  ....
```
When using the --region_of_interest flag, you can select one or more of the following anatomical domains:

[frontal, parietal, temporal, occipital, cerebellum, limbic, subcortical]


For Finetuning: 
```bash
bash scripts/adhd200_finetune/ft_neurostorm_task3.sh
```




Evaluation metrics:

* Classification Accuracy (ACC)
* AUCROC

