#This is a pretraining script
# Set default task_name
batch_size="24"

# Override with the arguments if provided
if [ ! -z "$1" ]; then
  batch_size=$1
fi

# We will use all aviailable GPUs, and automatically set the same batch size for each GPU
export CUDA_VISIBLE_DEVICES=0,1,2
export NCCL_P2P_DISABLE=1

# Construct project_name using task_name
project_name="adhd200_ts_binary"

python main.py \
  --accelerator gpu \
  --max_epochs 20 \
  --num_nodes 1 \
  --strategy ddp \
  --loggername tensorboard \
  --dataset_name ADHD200 \
  --image_path  ./data/ADHD200_MNI_to_TRs_minmax \
  --batch_size "$batch_size" \
  --num_workers "$batch_size" \
  --project_name "$project_name" \
  --limit_training_samples 1.0 \
  --c_multiplier 2 \
  --last_layer_full_MSA True \
  --pretraining \
  --use_mae \
  --spatial_mask atlas \
  --time_mask tube \
  --region_of_interest limbic,frontal \
  --n_mask_rois 120 \
  --mask_ratio 0.1 \
  --dataset_split_num 1 \
  --seed 1 \
  --learning_rate 5e-5 \
  --model neurostorm \
  --depth 2 2 6 2 \
  --embed_dim 36 \
  --sequence_length 20 \
  --img_size 96 96 96 20 \
  --first_window_size 4 4 4 4 \
  --window_size 4 4 4 4 




