from matplotlib import rcParams
import matplotlib.pyplot as plt

# Configure matplotlib to use LaTeX for rendering text
rcParams['text.usetex'] = True
rcParams['font.family'] = 'serif'
rcParams['font.serif'] = ['Computer Modern']

# Default colors for plotting
default_colors = ['#1f77b4', '#ff7f0e', '#2ca02c', '#d62728', '#9467bd', '#8c564b', '#e377c2',
                  '#7f7f7f', '#bcbd22', '#17becf']

# x values (as strings for LaTeX rendering of scientific notation)
x = ["1e-1", "8e-2", "6e-2", "4e-2", "2e-2", "1e-2", "1e-3"]

# Corresponding y1 values
y1 = [
    0.381772398667858,  
    0.22743886709213257,
    0.11371943354606628,
    0.048736900091171265,
    0.016245635226368904,
    0.008122816992933149,  
    0.008122816992933149
]

# y2 values (all zeros)
y2 = [0, 0, 0, 0, 0, 0, 0]

# Create the plot figure and axis
fig, ax = plt.subplots()

# Plot y1 and y2 with labels and appropriate colors/markers
ax.plot(x, y1, label=r"$\mathcal{C}$-symmetric", color=default_colors[1], marker='o', markersize=6)
ax.plot(x, y2, label=r"$\mathcal{D}$-symmetric", color=default_colors[2], marker='o', markersize=6)

# Set the labels for x and y axes
plt.xlabel(r"Deviation Error $\epsilon$", fontsize=20)
plt.ylabel(r"Proportion (\%)", fontsize=20)

# Set x-ticks with the actual x values and format them with LaTeX
plt.xticks(ticks=x, labels=x, fontsize=16)

# Set y-ticks font size
plt.yticks(fontsize=16)

# Add legend to the plot
plt.legend(fontsize=16)

# Set the plot title
plt.title("ModelNet40", fontsize=20)

# Save the figure in PDF format with tight layout
plt.savefig("real_world_assessment/output/ModelNet40.pdf", bbox_inches='tight')

# Show the plot (if running interactively)
plt.show()