from matplotlib import rcParams
import matplotlib.pyplot as plt
rcParams['text.usetex'] = True
rcParams['font.family'] = 'serif'
rcParams['font.serif'] = ['Computer Modern']

default_colors = ['#1f77b4', '#ff7f0e', '#2ca02c', '#d62728', '#9467bd', '#8c564b', '#e377c2',
 '#7f7f7f', '#bcbd22', '#17becf']

x = ["1e-1", "1e-2", "1e-3", "1e-4", "1e-5", "1e-6"]

y1 = [
    0.09630745006917321,
    0.09325007070189786,
    0.09095703617644137,
    0.07490579449824583,
    0.02445903493820272,
    0.00458606905091301
]

y2 = [
    0.08560662228370952,
    0.08331358775825301,
    0.0810205532327965,
    0.07031972544733282,
    0.02140165557092738,
    0.00458606905091301
]


# Create the plot figure and axis
fig, ax = plt.subplots()

# Plot y1 and y2 with respective labels and colors
ax.plot(x, y1, label=r"$\mathcal{C}$-symmetric", color=default_colors[1], marker='o', markersize=6)
ax.plot(x, y2, label=r"$\mathcal{D}$-symmetric", color=default_colors[2], marker='o', markersize=6)

# Set the labels for x and y axes
plt.xlabel(r"Deviation Error $\epsilon$", fontsize=20)
plt.ylabel(r"Proportion (\%)", fontsize=20)

# Set tick size for both axes
plt.xticks(fontsize=16)
plt.yticks(fontsize=16)

# Add legend to the plot
plt.legend(fontsize=16)

# Set the plot title
plt.title("QM9", fontsize=20)

# Save the figure in PDF format to the specified directory
plt.savefig("real_world_assessment/output/QM9.pdf", bbox_inches='tight')