#!/bin/bash

# Define the dimension list
dimensions=("subject_consistency" "background_consistency" "aesthetic_quality" "imaging_quality" "object_class" "multiple_objects" "color" "spatial_relationship" "scene" "temporal_style" "overall_consistency" "human_action" "temporal_flickering" "motion_smoothness" "dynamic_degree" "appearance_style")

# Base path for videos
run_name=${1:-"t2v_turbo_vc2"}
num_infer_step=${2:-4}
num_iters=${3:-10000}

base_path="./sampled_vbench_videos/${run_name}/ckpt_${num_iters}/${num_infer_step}_steps"
output_path="./eval_vbench/${run_name}/ckpt_${num_iters}/${num_infer_step}_steps"
# Loop over each dimension
for i in "${!dimensions[@]}"; do
    # Get the dimension and corresponding folder
    dimension=${dimensions[i]}

    # Construct the video path
    videos_path="${base_path}"
    echo "$dimension $videos_path"
    # Run the evaluation script
    vbench evaluate --videos_path $videos_path --dimension $dimension --output_path $output_path
done