import os
from sys import argv
import pandas as pd
from pandas.errors import EmptyDataError

BASE = argv[1]
OUT = argv[2]
VARIANCE_DIR = "covariances/" + OUT

if __name__ == '__main__':
    os.makedirs("covariances", exist_ok=True)
    os.makedirs(VARIANCE_DIR, exist_ok=True)
    for dir in os.listdir(BASE):
        full_dir = BASE + "/" + dir
        cols = []
        cols_names = []
        all_assets = sorted(os.listdir(full_dir))
        for asset in all_assets:
            asset_name = asset.replace(".csv", "")
            try:
                df = pd.read_csv(full_dir + "/" + asset, usecols=["close"])
            except EmptyDataError:
                print("Empty file", full_dir + "/" + asset)
                continue
            returns = df["close"] / df["close"].shift()
            returns = returns[1:-1]
            cols_names.append(asset_name)
            cols.append(returns)
        full_df = pd.DataFrame({x: y for x, y in zip(cols_names, cols)})
        full_df = full_df.reindex(sorted(full_df.columns), axis=1)
        covs = full_df.cov().reset_index(names="index")
        covs.to_csv(VARIANCE_DIR + "/" + dir + ".csv", index=False)

