# -*- coding: utf-8 -*-
"""toy_dataset_gan_nonlinear.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1BqE7BnsCm3o-TPVjzEc692rKOnI1hhed
"""

# import comet_ml
# comet_ml.config.save(api_key="CX4nLhknze90b8yiN2WMZs9Vw")

import torch
import torch.nn as nn
import torch.optim as optim
import numpy as np
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec
import os
from torch.autograd import Variable
from copy import deepcopy

batch_size = 100

import random

def gaussians(index):
  scale = 2.
  centers1 = [
    (0, 1),
    (1. / np.sqrt(2), 1. / np.sqrt(2)),
    (1, 0),
    (1. / np.sqrt(2), -1. / np.sqrt(2)),
    (0, -1),
    (-1. / np.sqrt(2), -1. / np.sqrt(2)),
    (-1, 0),
    (-1. / np.sqrt(2), 1. / np.sqrt(2)),
  ]

  centers2 = []
  theta = np.pi/8
  a = np.cos(theta)
  b = np.sin(theta)
  for p in centers1:
    centers2.append((p[0]*a - p[1]*b, p[1]*a + p[0]*b))

  centers1 = [(scale * x, scale * y) for x, y in centers1]
  centers2 = [(scale * x, scale * y) for x, y in centers2]
  count = 0
  while True:
    count+=1
    dataset = []
    for i in range(batch_size):
      point = np.random.randn(2) * 0.05
      center = centers2[index]
      point[0] += center[0]
      point[1] += center[1]
      dataset.append(point)
    dataset = np.array(dataset, dtype='float32')
    dataset /= 1.414  # stdev
    yield dataset

points_all = []
for index in range(8):
  data = gaussians(index)
  points = next(data)
  points_all.append(points)


all_points = []
for x in points_all:
  for i in range(10):
    all_points.append(x[i])

dataset = np.copy(points_all)

cuda = True if torch.cuda.is_available() else False
print("device cude:", cuda)

if cuda==False:
  print(notavariable)

import torch.nn.functional as F

class Wgen(nn.Module):
  
  def __init__(self, args):
    super(Wgen, self).__init__()

    self.model = nn.Sequential(
                 nn.Linear(args.Z_dim, args.dim1),
                #  nn.BatchNorm1d(args.dim1, 0.8),
                 nn.LeakyReLU(),
                 nn.Linear(args.dim1, args.dim2),
                #  nn.BatchNorm1d(args.dim2, 0.8),
                 nn.LeakyReLU(),
                 nn.Linear(args.dim2, args.dim3),
                #  nn.BatchNorm1d(args.dim3, 0.8),
                 nn.LeakyReLU(),
                 nn.Linear(args.dim3, args.out_dim),
                #  nn.Sigmoid,
                 nn.Tanh()
    )

  def forward(self, z):

    img_gen = self.model(z)
    return 2*img_gen

class Wdis(nn.Module):
  
  def __init__(self, args):
    super(Wdis, self).__init__()

    self.model = nn.Sequential(
                 nn.Linear(args.img_dim, args.dim1),
                #  nn.BatchNorm1d(args.dim1, 0.8),
                 nn.ReLU(),
                 nn.Linear(args.dim1, args.dim2),
                #  nn.BatchNorm1d(args.dim2, 0.8),
                 nn.ReLU(),
                 nn.Linear(args.dim2, 1),
                 nn.Sigmoid()
    )

  def forward(self, x):
    out = self.model(x)
    return out

import argparse

parser = argparse.ArgumentParser(description='CNN text classificer')
# learning
parser.add_argument('-lr', type=float, default=0.0001, help='initial learning rate [default: 0.001]')
parser.add_argument('-epochs', type=int, default=300, help='number of epochs for train [default: 256]')
parser.add_argument('-batch_size', type=int, default=128, help='batch size for training [default: 64]')
parser.add_argument('-Z_dim', type=int, default = 10)
parser.add_argument('-dim1', type=int, default = 128)
parser.add_argument('-dim2', type=int, default = 512)
parser.add_argument('-dim3', type=int, default = 1024)
parser.add_argument('-out_dim', type=int, default = 2)
parser.add_argument('-img_dim', type=int, default = 2)
# data 
parser.add_argument('-shuffle', action='store_true', default=True, help='shuffle the data every epoch')
# model
parser.add_argument('-dropout', type=float, default=0.5, help='the probability for dropout [default: 0.5]')
# device
parser.add_argument('-device', type=int, default=-1, help='device to use for iterate data, -1 mean cpu [default: -1]')
parser.add_argument('-no-cuda', action='store_true', default=False, help='disable the gpu')

args = parser.parse_args(args=[])

gen = Wgen(args)

# multi dis

n_dis = 4
multi_dis = []
for i in range(n_dis):
  multi_dis.append(Wdis(args))
  if cuda:
    multi_dis[i].cuda()

Tensor = torch.cuda.FloatTensor if cuda else torch.FloatTensor

if cuda:
  print("Using cuda")
  gen.cuda()


gen_optim = optim.Adam(gen.parameters(), lr = args.lr, betas = (0.5,0.999))
# dis_optim = optim.Adam(dis.parameters(), lr = args.lr, betas = (0.0,0.9))

# gen_optim = optim.SGD(gen.parameters(), lr=args.lr, momentum=0.0)

multi_dis_optim = []
for i in range(n_dis):
  # multi_dis_optim.append(optim.SGD(multi_dis[i].parameters(), lr=args.lr, momentum=0.0))
  multi_dis_optim.append(optim.Adam(multi_dis[i].parameters(), lr = args.lr, betas = (0.5,0.999)))

class gnn(nn.Module):
  
  def __init__(self):
    super(gnn, self).__init__()

    self.model = nn.Sequential(
                 nn.Linear(1, 10),
                 nn.LeakyReLU(),
                 nn.Linear(10, 100),
                 nn.LeakyReLU(),
                 nn.Linear(100,50),
                 nn.LeakyReLU(),
                 nn.Linear(50, 1),
                #  nn.Sigmoid,
                 nn.Tanh()
    )

  def forward(self, z):

    img_gen = self.model(z)
    return img_gen


functions = []

# gnns = []
# for i in range(10):
#   gnns.append(gnn())

# path = 'nonlinear_functions1.p'
# f = open(path,'rb')
# gnns = torch.load(f)
# f.close()
# print(len(gnns))

# with torch.no_grad():
#   for i in range(int(len(gnns)/2)):
#     print(i*2)
#     # g1 = gnns[i*2]
#     # g2 = gnns[i*2 +1]
#     functions.append(lambda x: gnns[0](torch.FloatTensor(x).view(x.shape[0],1)).view(x.shape[0]).detach().numpy())
#     functions.append(lambda x: gnns[1](torch.FloatTensor(x).view(x.shape[0],1)).view(x.shape[0]).detach().numpy())

# functions.append(lambda x: x)


def add_nonlinearity(x):

  i = 0
  for f in functions:
 
    i+=1
    i = i%2
    x[:,i] = x[:,i]*f(x[:,i-1])
      
  return x

def remove_nonlinearity(x):

  j = len(functions)
  eps = 10**(-10)
  i = j%2
  while j:
    j-=1
    f = functions[j]
    den = f(x[:,i-1])
    den[abs(den) < eps] = eps
    x[:,i] = x[:,i]/den
    i-=1
    i = i%2


  return x

# Transform matrix

A = (np.random.rand(1000, 2+1) -0.5 )*2  # keep A values in [-1,1]

def transform(x):
  # x = add_nonlinearity(x)
  x = np.vstack((x.T, np.ones(x.shape[0])))
  B = np.dot(A, x)
  B = B + np.random.normal(0 , 0 , B.shape)
  # B = add_nonlinearity(B)
  # B = B*B*B  
  return B.T

def detransform(x):
  # x = np.cbrt(x)
  # x = remove_nonlinearity(x)
  x = np.dot(np.dot(np.linalg.inv(np.dot(A.T,A)), A.T), x.T).T
  return x[:,:2]
  # return x

from torch.utils.data import Dataset, DataLoader

class toy_dataset(Dataset):
  def __init__(self, points):
    self.points = points
    print(len(points))

  def __len__(self):
    return len(self.points)
  
  def __getitem__(self,idx):
    return self.points[idx]


# dataset_transformed = transform(np.copy(dataset))
# dataset_nonlinear = add_nonlinearity(np.copy(dataset))
# dataset_nonlinear[:,0] = dataset_nonlinear[:,0]*1e3
# dataset_nonlinear[:,1] = dataset_nonlinear[:,1]*1e7
# print(dataset_nonlinear[:10])
# toy_set = toy_dataset(dataset_nonlinear)

dataloaders = []
for i in range(n_dis):
  # dataset_nonlinear = add_nonlinearity(np.copy(dataset[i]))
  # dataset_nonlinear[:,0] = dataset_nonlinear[:,0]*1e1
  # dataset_nonlinear[:,1] = dataset_nonlinear[:,1]*1e0
  print(np.concatenate((dataset[2*i], dataset[2*i+1])).shape)
  toy_set = toy_dataset(np.copy(np.concatenate((dataset[2*i], dataset[2*i+1]))))
  dataloaders.append(DataLoader(toy_set, batch_size = args.batch_size, shuffle = True))

# all_points = add_nonlinearity(np.array(all_points))
# all_points[:,0] = all_points[:,0]*1e1
# all_points[:,1] = all_points[:,1]*1e0

# dataloader = DataLoader(toy_set, batch_size = args.batch_size, shuffle = True)

def train(gen, dis, gen_optim, dis_optim, args, experiment=0):
  gen.train()
  loss_func = torch.nn.BCELoss()

  # experiment.train()
  n_critic = 1
  total_it = 40e3
  it = -1

  change_dis = 1

  while(True):

    if it>= total_it:
      break

    for humus in range(10):
      it+=1

      # if it%ewc_add == 0:
      #   break

      gen.train()
      for i in range(n_dis):
        multi_dis[i].train()
        for p in multi_dis[i].parameters():
          p.requires_grad = True
        
        multi_dis_optim[i].zero_grad()

      for p in gen.parameters():
          p.requires_grad = True

      for dis_index in range(n_dis):
        
        for imgs in dataloaders[dis_index]:
          break
        
        z = Variable(torch.randn(imgs.size()[0], args.Z_dim).cuda())
        ones = Variable(Tensor(imgs.size()[0], 1).fill_(1.0), requires_grad=False)
        zeros = Variable(Tensor(imgs.size()[0], 1).fill_(0.0), requires_grad=False)

        # imgs = next(data)
        # imgs = torch.tensor(imgs)
        imgs = Variable(imgs.type(Tensor))

        critic_fake = multi_dis[dis_index](gen(z))
        critic_real = multi_dis[dis_index](imgs)

        critic_real_loss = loss_func(critic_real, ones)
        critic_fake_loss = loss_func(critic_fake, zeros)

        critic_loss = critic_real_loss + critic_fake_loss
        critic_loss.backward()

        multi_dis_optim[dis_index].step()

      # weight clipping...

      # for p in dis.parameters():
      #   p.data.clamp_(-0.01, 0.01)

      # dis_optim.zero_grad()

      # generator
      if it%n_critic == 0:

        gen.train()

        gen_optim.zero_grad()
        ones = Variable(Tensor(args.batch_size, 1).fill_(1.0), requires_grad=False)
        z = Variable(torch.randn(args.batch_size, args.Z_dim).cuda())
        critic_fakes = []

        # for i in range(64):

        #   z = Variable(torch.randn(1, args.Z_dim).cuda())

        #   fake_img = gen(z)
        #   critic_fake = None
        #   quarters = checkQuarter(fake_img)
        #   q = quarters[0]
        #   for d in range(n_dis):
        #     if d==q:
        #       continue
        #     if critic_fake == None:
        #       critic_fake = multi_dis[d](fake_img)
        #     else:
        #       critic_fake = torch.add(critic_fake, multi_dis[d](fake_img))
        #   critic_fake = critic_fake/(n_dis - 1)

        #   if critic_fakes == None:
        #     critic_fakes = critic_fake
        #   else:
        #     critic_fakes = torch.cat((critic_fakes, critic_fake), dim = 0)
        
        # print(critic_fakes.size())
          
        
          


        # critic_fakes = []
        # fake_img = gen(z)
        # critic_fakes = None
        # critic_fakes2 = None

        # quarters = checkQuarter(fake_img)

        # for i in range(fake_img.size()[0]):
        #   q = quarters[i]
        #   fk_img = fake_img[i]
        #   for d in range(n_dis):
        #     if d != q:
        #       critic_fake = multi_dis[d](fk_img)
        #       if critic_fakes2 == None:
        #         critic_fakes2 = critic_fake
        #       else:
        #         critic_fakes2 = torch.add(critic_fakes2, critic_fake)
        #   critic_fake = critic_fakes2/(n_dis -1)
        #   # print(critic_fake.size())
        #   # for p in multi_dis[i].parameters():
        #   #   p.requires_grad = False
        #   # critic_fake = multi_dis[q](fk_img)
        #   if critic_fakes == None:
        #     critic_fakes = critic_fake.unsqueeze(0)
        #   else:
        #     # critic_fakes = torch.max(critic_fakes, critic_fake)
        #     critic_fakes = torch.cat((critic_fakes, critic_fake.unsqueeze(0)), dim = 0)

        # q = quarters[0]
        fake_img = gen(z)
        lit = np.zeros(n_dis)
        for i in range(n_dis):
          # if i ==q:
          #   continue
          critic_fake = multi_dis[i](fake_img)
          critic_fakes.append(critic_fake)
          lit[i] = torch.sum(critic_fake).item()
          # if critic_fakes == None:
          #   critic_fakes = critic_fake
          # else:
          #   # critic_fakes = torch.max(critic_fakes, critic_fake)
          #   critic_fakes = torch.add(critic_fakes, critic_fake)
        q = np.argmax(lit)
        flag = False
        for i in range(len(critic_fakes)):
          if i == q:
            continue
          if flag == False:
            critic_fake = critic_fakes[i]
            flag = True
          else:
            critic_fake = torch.add(critic_fake, critic_fakes[i])
          

        critic_fake = critic_fake/(n_dis - 1)
        # print(critic_fake.size())
        
        # if it%500 == 0:
        #   print(quarters)

        gen_loss = loss_func(critic_fake, ones)

        gen_loss.backward()
        gen_optim.step()


      if it%500 == 0:

        # if loss_ewc!=0:
        #   print(loss_ewc.item())

        gen.eval()
        for i in range(n_dis):
          multi_dis[i].eval()
          for p in multi_dis[i].parameters():
            p.requires_grad = True
        for p in gen.parameters():
          gen.requires_grad = False

        print(it)
        print("gen_loss:{}, dis_loss: {}".format(gen_loss.cpu().data.numpy(), critic_loss.cpu().data.numpy()))
        print('------')

        # experiment.log_metric("generator_loss", gen_loss.item())
        # experiment.log_metric("critic_loss", critic_loss.item())

        # plot

        z = Variable(torch.randn(args.batch_size, args.Z_dim).cuda())

        generated_points = gen(z).cpu().data.numpy()
        # print(generated_images[0])
        
        fig = plt.figure(figsize = (4*9 + 9,4))

        ax=fig.add_subplot(191, label="1")
        # ax.set_xlim([-2,2])
        # ax.set_ylim([-2,2])
        

        for x in all_points:
          ax.scatter(x[0],x[1],c = 'g')

        for x in generated_points:
          ax.scatter(x[0],x[1], c = 'b')
        
        xp = np.linspace(-1.5,1.5,100)
        yp = np.linspace(-1.5 ,1.5,100)

        Dinput = []
        for i in range(len(xp)):
          for j in range(len(yp)):
            Dinput.append([xp[i],yp[j]])
        Dinput = np.array(Dinput)
        # Dinput = add_nonlinearity(Dinput)
        # Dinput[:,0] = Dinput[:,0]*1e1
        # Dinput[:,1] = Dinput[:,1]*1e0

        for i in range(n_dis):

          ax2=fig.add_subplot(191 + i + 1, frame_on=False)

          Z = multi_dis[i](torch.Tensor(Dinput).cuda())
          # Z = dis(torch.Tensor(Dinput).cuda())


          Z = Z.cpu().detach().numpy().reshape((len(xp),len(yp)))

          # ax = sns.heatmap(Z, alpha = 0.3).invert_yaxis()
          ax2.imshow(Z, cmap = 'plasma', aspect = 'auto', alpha = 1, origin='lower', vmin = 0.0, vmax = 0.99)
        
        ax.xaxis.tick_top()
        ax.yaxis.tick_right()
        
        # experiment.log_figure(figure=plt, figure_name = "figure_" + str(it))
        plt.show()
        # plt.close()

# from comet_ml import Experiment
# experiment = comet_ml.Experiment(project_name="ring_multi_modespec_GAN")

# exp_parameters = {
#     "data": "8gaussians_linear",
#     "model": "GAN_og_noBN",
#     "opt_gen": "ADAM_lr_0.0001",
#     "opt_dis": "ADAM_lr_0.0001",
#     "z_dim": 10,
#     "n_dis": 8,
#     "change_dis": 1,
#     "n_critic": 1,
#     "teacher": "mean",
#     "dataset_size": 800,
# }

# experiment.log_parameters(exp_parameters)

train(gen, multi_dis, gen_optim, multi_dis_optim, args, experiment=0)