from FedUtils.models.emnist.cnn import Model
import torch
from functools import partial
from FedUtils.fed.fedcurv import FedCurv
from pyvacy import optim

config = {

    "seed": 1,
    "model": Model,
    "inner_opt":partial(optim.DPSGD, lr=2e-1, weight_decay=0, l2_norm_clip=1.0, noise_multiplier=0.01, batch_size=24),
    "optimizer": FedCurv,
    "model_param": (10,),
    "inp_size": (784,),
    "train_path": "data/emnist/data_10000/train/",
    "test_path": "data/emnist/data_10000/test/",
    "clients_per_round": 20,
    "num_rounds": 500,
    "eval_every": 1,
    "drop_percent": 0.0,
    "num_epochs": 20,
    "batch_size": 24,
    "use_fed": 1,
    "log_path": "tasks/emnist/FedCurv_DP/train.log",
    "eval_train": False,
    "train_transform": None,
    "test_transform": None,
    "gamma": 1e-4


}
