### Preparation

Download the ImageNet dataset (https://www.image-net.org/download.php).
Install PyTorch (https://pytorch.org/).
Install apex (https://github.com/NVIDIA/apex) for LARS optimizer needed in linear evaluation.

### Pre-training

```
python main_pretrain.py --dist-url 'tcp://localhost:10001' \
  --multiprocessing-distributed --world-size 1 --rank 0 \
  --save-path [path to a folder where checkpoints will be saved] \
  [your imagenet-folder with train and val folders]
```

### k-nearest Neighbors

```
python main_knn.py --dist-url 'tcp://localhost:10001' \
  --multiprocessing-distributed --world-size 1 --rank 0 \
  --pretrained [path to a pre-trained checkpoint] \
  [your imagenet-folder with train and val folders]
```

### Linear Evaluation

```
python main_lincls.py --dist-url 'tcp://localhost:10001' \
  --multiprocessing-distributed --world-size 1 --rank 0 \
  --pretrained [path to a pre-trained checkpoint] --lars \
  [your imagenet-folder with train and val folders]
```
