export HF_ALLOW_CODE_EVAL=1
export CUDA_VISIBLE_DEVICES=2,3
model="your dream path"



export BASE_RATE=0.9
export RATE_FLEX=0.1
export COLD_START=6
export DEAN_TOPP=0.9
export DEAN_MODE="lrd"
export DIFFTHRESHOLD=0.1
export KLTHRESHOLD=0.1


tasks="gsm8k_cot mbpp math500"
nshots="8 3 8"
lengths="512 512 512"
read -ra TASKS_ARRAY <<< "$tasks"
read -ra NSHOTS_ARRAY <<< "$nshots"
read -ra LENGTH_ARRAY <<< "$lengths"

HF_ALLOW_CODE_EVAL=1 accelerate launch  --num_processes=2 --main_process_port 12347 eval.py --model dream \
    --model_args pretrained=${model},max_new_tokens=512,diffusion_steps=512,add_bos_token=true,escape_until=true \
    --tasks humaneval \
    --num_fewshot 0 \
    --batch_size 1 \
    --output_path evals_results/humaneval-ns0 \
    --log_samples \
    --confirm_run_unsafe_code
# ## NOTICE: use postprocess for humaneval
# python postprocess_code.py {the samples_xxx.jsonl file under output_path}

for i in "${!TASKS_ARRAY[@]}"; do
    output_path=evals_results/${TASKS_ARRAY[$i]}-ns${NSHOTS_ARRAY[$i]}
    echo "Task: ${TASKS_ARRAY[$i]}, Shots: ${NSHOTS_ARRAY[$i]}; Output: $output_path"
    HF_ALLOW_CODE_EVAL=1 accelerate launch --num_processes=2 --main_process_port 12343 eval.py --model dream \
        --model_args pretrained=${model},max_new_tokens=${LENGTH_ARRAY[$i]},diffusion_steps=${LENGTH_ARRAY[$i]},add_bos_token=true \
        --tasks ${TASKS_ARRAY[$i]} \
        --num_fewshot ${NSHOTS_ARRAY[$i]} \
        --batch_size 1 \
        --output_path $output_path \
        --log_samples \
        --confirm_run_unsafe_code
done