
export CUDA_VISIBLE_DEVICES=2,3
model="your dream path"
export HF_DATASETS_TRUST_REMOTE_CODE=true


export BASE_RATE=0.9
export RATE_FLEX=0.1
export COLD_START=6
export DEAN_TOPP=0.9
export DEAN_MODE="lrd"
export DIFFTHRESHOLD=0.1
export KLTHRESHOLD=0.1
HF_ALLOW_CODE_EVAL=1 PYTHONPATH=. accelerate launch --num_processes=2 --main_process_port 12334 -m lm_eval \
    --model diffllm \
    --model_args pretrained=${model},trust_remote_code=True,max_new_tokens=512,diffusion_steps=512,dtype="bfloat16",alg="entropy" \
    --tasks humaneval_instruct \
    --device cuda \
    --batch_size 1 \
    --num_fewshot 0 \
    --output_path output_reproduce/humaneval \
    --log_samples --confirm_run_unsafe_code \
    --apply_chat_template \
    --limit 4

PYTHONPATH=. accelerate launch --num_processes=2 --main_process_port 12334 -m lm_eval \
    --model diffllm \
    --model_args pretrained=${model},trust_remote_code=True,max_new_tokens=512,diffusion_steps=512,dtype="bfloat16",alg="entropy" \
    --tasks gsm8k_cot \
    --device cuda \
    --batch_size 1 \
    --num_fewshot 0 \
    --output_path output_reproduce/gsm8k \
    --log_samples --confirm_run_unsafe_code \
    --apply_chat_template

PYTHONPATH=. accelerate launch --num_processes=2 --main_process_port 12334 -m lm_eval \
    --model diffllm \
    --model_args pretrained=${model},trust_remote_code=True,max_new_tokens=512,diffusion_steps=512,dtype="bfloat16",top_p=0.9,alg="entropy" \
    --tasks math500 \
    --device cuda \
    --batch_size 1 \
    --num_fewshot 0 \
    --output_path ./output_reproduce/math \
    --log_samples --confirm_run_unsafe_code \
    --apply_chat_template 
python metrics/math500.py \
    --model_path "${model}" \
    --res_path output_reproduce/math
    
HF_ALLOW_CODE_EVAL=1 PYTHONPATH=. accelerate launch --num_processes=2 --main_process_port 12334 -m lm_eval \
    --model diffllm \
    --model_args pretrained=${model},trust_remote_code=True,max_new_tokens=512,diffusion_steps=512,dtype="bfloat16",top_p=0.9,alg="entropy" \
    --tasks mbpp_instruct \
    --device cuda \
    --batch_size 1 \
    --num_fewshot 0 \
    --output_path output_reproduce/mbpp \
    --log_samples --confirm_run_unsafe_code \
    --apply_chat_template