(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     24868,        469]
NotebookOptionsPosition[     23708,        445]
NotebookOutlinePosition[     24110,        461]
CellTagsIndexPosition[     24067,        458]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Generate", " ", "loss", " ", "unsing", " ", "Theorem", " ", "1"}],
    "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"DDphi", "[", "x_", "]"}], ":=", 
     RowBox[{"E", "^", 
      RowBox[{"(", 
       RowBox[{"2", "*", "x"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Dphi", "[", "x_", "]"}], ":=", 
    RowBox[{"Evaluate", "[", 
     RowBox[{"Integrate", "[", 
      RowBox[{
       RowBox[{"DDphi", "[", "x", "]"}], ",", "x"}], "]"}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"Dphi", "[", "x", "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"phi", "[", "x_", "]"}], ":=", 
    RowBox[{"Evaluate", "[", 
     RowBox[{"Integrate", "[", 
      RowBox[{
       RowBox[{"Integrate", "[", 
        RowBox[{
         RowBox[{"DDphi", "[", "x", "]"}], ",", "x"}], "]"}], ",", "x"}], 
      "]"}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g", "[", "y_", "]"}], ":=", 
    RowBox[{"x", "/.", " ", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"y", "==", 
         RowBox[{"Dphi", "[", "x", "]"}]}], "}"}], ",", "x", ",", "Reals"}], 
      "]"}]}]}], "\[IndentingNewLine]", 
   RowBox[{"g", "[", "y", "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Psiinv", "[", "y_", "]"}], ":=", 
    RowBox[{
     RowBox[{"g", "[", "y", "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"g", "[", "y", "]"}]}], ")"}]}]}], "\[IndentingNewLine]", 
   RowBox[{"Psiinv", "[", "y", "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"gamma", "[", "eta_", "]"}], ":=", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"phi", "[", 
       RowBox[{"eta", "/", 
        RowBox[{"(", 
         RowBox[{"1", "-", "eta"}], ")"}]}], "]"}]}], 
     RowBox[{"(", 
      RowBox[{"1", "-", "eta"}], ")"}]}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Dgamma", "[", "eta_", "]"}], ":=", 
    RowBox[{"Evaluate", "[", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"gamma", "[", "eta", "]"}], ",", "eta"}], "]"}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lossP", "[", "y_", "]"}], ":=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"gamma", "[", 
       RowBox[{"Psiinv", "[", "y", "]"}], "]"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"Psiinv", "[", "y", "]"}]}], ")"}], "*", 
       RowBox[{"Dgamma", "[", 
        RowBox[{"Psiinv", "[", "y", "]"}], "]"}]}]}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lossQ", "[", "y_", "]"}], ":=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"gamma", "[", 
       RowBox[{"Psiinv", "[", "y", "]"}], "]"}], "-", 
      RowBox[{
       RowBox[{"Psiinv", "[", "y", "]"}], "*", 
       RowBox[{"Dgamma", "[", 
        RowBox[{"Psiinv", "[", "y", "]"}], "]"}]}]}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"lossP", "[", "y", "]"}], "\[IndentingNewLine]", 
   RowBox[{"lossQ", "[", "y", "]"}], "\[IndentingNewLine]", 
   RowBox[{"Dphi", "[", "x", "]"}], "\[IndentingNewLine]", 
   RowBox[{"g", "[", "y", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.926046657530356*^9, 3.9260467971640773`*^9}, {
   3.926047098755455*^9, 3.926047152302191*^9}, 3.926047287104001*^9, {
   3.9260473511372185`*^9, 3.9260473775472345`*^9}, {3.926047461851426*^9, 
   3.926047516369261*^9}, {3.9260475885262995`*^9, 3.926047604201888*^9}, {
   3.92604772989695*^9, 3.926047732996933*^9}, {3.926047793838709*^9, 
   3.9260477972545137`*^9}, {3.926047870413623*^9, 3.926047981480179*^9}, 
   3.926048081017465*^9, {3.926048115813208*^9, 3.926048116040897*^9}, {
   3.9261336465967216`*^9, 3.926133728724005*^9}, {3.9261339982718205`*^9, 
   3.9261340244085274`*^9}, {3.926134121729923*^9, 3.926134233693152*^9}, {
   3.926134274618384*^9, 3.9261342961557918`*^9}, {3.926134327783753*^9, 
   3.926134396300989*^9}, {3.926134446664302*^9, 3.9261344546958623`*^9}, {
   3.926134504249916*^9, 3.926134504423772*^9}, {3.926134546301887*^9, 
   3.926134564258529*^9}, {3.92613464197908*^9, 3.9261346424492702`*^9}, {
   3.9261346733836803`*^9, 3.92613472174547*^9}, 3.9261427183661814`*^9, {
   3.926143807290069*^9, 3.926143874783767*^9}, {3.9261439553687086`*^9, 
   3.926144019844109*^9}, {3.9261442736514235`*^9, 3.926144376745064*^9}, {
   3.926144415108583*^9, 3.926144425463472*^9}, {3.9261444848308206`*^9, 
   3.926144543674463*^9}, 3.926144840770576*^9, {3.926145171089683*^9, 
   3.926145177379005*^9}, {3.92709883646044*^9, 3.9270988385404396`*^9}, 
   3.927098886148808*^9, 3.9270997548497076`*^9, {3.9270998917074018`*^9, 
   3.927099929838605*^9}, {3.927099964463359*^9, 3.9270999871601357`*^9}, {
   3.927100181155182*^9, 3.927100191307142*^9}, {3.9271002235405*^9, 
   3.9271002383487825`*^9}, {3.9271003055532875`*^9, 3.927100317395134*^9}, {
   3.92710034857101*^9, 3.927100415340432*^9}, {3.927100460478907*^9, 
   3.9271004645427*^9}, {3.927101296750883*^9, 3.927101312068459*^9}, 
   3.927101958986289*^9, {3.927102092191389*^9, 3.927102094045727*^9}, {
   3.927102246391876*^9, 3.92710228113643*^9}, 3.927104550211809*^9, 
   3.9271240679882317`*^9, {3.927124113118599*^9, 3.927124150556824*^9}, {
   3.927124284051152*^9, 3.927124287209498*^9}, 3.927124320128259*^9, 
   3.927124650389329*^9, {3.9271247294899135`*^9, 3.9271247506248093`*^9}, {
   3.927124895682983*^9, 3.927124914557879*^9}, {3.927185262685213*^9, 
   3.927185304414548*^9}, {3.940997853945175*^9, 
   3.9409978541176796`*^9}},ExpressionUUID->"2091e894-d3b4-4fde-843f-\
b5cb93fbd1bb"],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"2", " ", "x"}]], "2"]], "Output",
 CellChangeTimes->{
  3.926047152963863*^9, 3.9260472874319015`*^9, {3.926047351630525*^9, 
   3.926047377922821*^9}, {3.926047462786542*^9, 3.9260475166471467`*^9}, {
   3.926047591489419*^9, 3.926047604592033*^9}, 3.9260477338080187`*^9, 
   3.9260477983804417`*^9, {3.9260478708639603`*^9, 3.926047981800996*^9}, 
   3.926048082325882*^9, 3.926048116387475*^9, 3.926133609196629*^9, {
   3.926133647349925*^9, 3.926133729297118*^9}, {3.9261339987441254`*^9, 
   3.926134024800729*^9}, {3.9261341239860716`*^9, 3.926134178207155*^9}, {
   3.926134209536233*^9, 3.926134234196685*^9}, {3.926134276618449*^9, 
   3.926134296583171*^9}, {3.926134328384896*^9, 3.926134396711558*^9}, {
   3.926134447072649*^9, 3.92613445512043*^9}, 3.926134504770557*^9, {
   3.92613454677303*^9, 3.926134564872676*^9}, 3.926134644408887*^9, {
   3.92613467451523*^9, 3.926134722817118*^9}, 3.9261427186812224`*^9, {
   3.926143785789668*^9, 3.926143824703295*^9}, {3.9261438634405136`*^9, 
   3.92614387549414*^9}, {3.9261439556527205`*^9, 3.926144020378787*^9}, {
   3.926144275120921*^9, 3.92614437726663*^9}, 3.9261444263664465`*^9, {
   3.926144486637223*^9, 3.926144544174923*^9}, 3.926144841385737*^9, 
   3.926145187610564*^9, {3.9270988219357643`*^9, 3.927098840166531*^9}, 
   3.927098886660016*^9, 3.92709975817117*^9, 3.9270998230224795`*^9, {
   3.927099892659016*^9, 3.927099930153096*^9}, {3.92709996565817*^9, 
   3.92709998747474*^9}, {3.927100182559022*^9, 3.927100191711195*^9}, {
   3.9271002271580086`*^9, 3.9271002387256184`*^9}, {3.927100306936891*^9, 
   3.92710031784838*^9}, {3.9271003516037254`*^9, 3.927100415714735*^9}, 
   3.927100464810094*^9, {3.927101297958349*^9, 3.9271013123995132`*^9}, 
   3.927101959537132*^9, {3.927102094564475*^9, 3.927102110840372*^9}, {
   3.927102246958084*^9, 3.927102281513492*^9}, 3.927104550636329*^9, 
   3.927124071070366*^9, {3.927124127709923*^9, 3.9271241581976576`*^9}, 
   3.927124287815303*^9, 3.927124320699244*^9, 3.927124651866125*^9, {
   3.927124729969536*^9, 3.927124751217626*^9}, {3.927124904776569*^9, 
   3.9271249150306444`*^9}, {3.927185254332079*^9, 3.927185305164613*^9}, 
   3.9409972940299454`*^9},
 CellLabel->"Out[3]=",ExpressionUUID->"5e24059d-b902-5547-8537-62e8e2cef185"],

Cell[BoxData[
 RowBox[{"{", 
  TemplateBox[{
    RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"Log", "[", 
        RowBox[{"2", " ", "y"}], "]"}]}], 
    RowBox[{"y", ">", "0"}]},
   "ConditionalExpression"], "}"}]], "Output",
 CellChangeTimes->{
  3.926047152963863*^9, 3.9260472874319015`*^9, {3.926047351630525*^9, 
   3.926047377922821*^9}, {3.926047462786542*^9, 3.9260475166471467`*^9}, {
   3.926047591489419*^9, 3.926047604592033*^9}, 3.9260477338080187`*^9, 
   3.9260477983804417`*^9, {3.9260478708639603`*^9, 3.926047981800996*^9}, 
   3.926048082325882*^9, 3.926048116387475*^9, 3.926133609196629*^9, {
   3.926133647349925*^9, 3.926133729297118*^9}, {3.9261339987441254`*^9, 
   3.926134024800729*^9}, {3.9261341239860716`*^9, 3.926134178207155*^9}, {
   3.926134209536233*^9, 3.926134234196685*^9}, {3.926134276618449*^9, 
   3.926134296583171*^9}, {3.926134328384896*^9, 3.926134396711558*^9}, {
   3.926134447072649*^9, 3.92613445512043*^9}, 3.926134504770557*^9, {
   3.92613454677303*^9, 3.926134564872676*^9}, 3.926134644408887*^9, {
   3.92613467451523*^9, 3.926134722817118*^9}, 3.9261427186812224`*^9, {
   3.926143785789668*^9, 3.926143824703295*^9}, {3.9261438634405136`*^9, 
   3.92614387549414*^9}, {3.9261439556527205`*^9, 3.926144020378787*^9}, {
   3.926144275120921*^9, 3.92614437726663*^9}, 3.9261444263664465`*^9, {
   3.926144486637223*^9, 3.926144544174923*^9}, 3.926144841385737*^9, 
   3.926145187610564*^9, {3.9270988219357643`*^9, 3.927098840166531*^9}, 
   3.927098886660016*^9, 3.92709975817117*^9, 3.9270998230224795`*^9, {
   3.927099892659016*^9, 3.927099930153096*^9}, {3.92709996565817*^9, 
   3.92709998747474*^9}, {3.927100182559022*^9, 3.927100191711195*^9}, {
   3.9271002271580086`*^9, 3.9271002387256184`*^9}, {3.927100306936891*^9, 
   3.92710031784838*^9}, {3.9271003516037254`*^9, 3.927100415714735*^9}, 
   3.927100464810094*^9, {3.927101297958349*^9, 3.9271013123995132`*^9}, 
   3.927101959537132*^9, {3.927102094564475*^9, 3.927102110840372*^9}, {
   3.927102246958084*^9, 3.927102281513492*^9}, 3.927104550636329*^9, 
   3.927124071070366*^9, {3.927124127709923*^9, 3.9271241581976576`*^9}, 
   3.927124287815303*^9, 3.927124320699244*^9, 3.927124651866125*^9, {
   3.927124729969536*^9, 3.927124751217626*^9}, {3.927124904776569*^9, 
   3.9271249150306444`*^9}, {3.927185254332079*^9, 3.927185305164613*^9}, 
   3.940997294602783*^9},
 CellLabel->"Out[6]=",ExpressionUUID->"ed1e03cc-178b-6540-a91f-f574cec94442"],

Cell[BoxData[
 RowBox[{"{", 
  TemplateBox[{
    FractionBox[
     RowBox[{"Log", "[", 
       RowBox[{"2", " ", "y"}], "]"}], 
     RowBox[{"2", " ", 
       RowBox[{"(", 
         RowBox[{"1", "+", 
           RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"Log", "[", 
               RowBox[{"2", " ", "y"}], "]"}]}]}], ")"}]}]], 
    RowBox[{"y", ">", "0"}]},
   "ConditionalExpression"], "}"}]], "Output",
 CellChangeTimes->{
  3.926047152963863*^9, 3.9260472874319015`*^9, {3.926047351630525*^9, 
   3.926047377922821*^9}, {3.926047462786542*^9, 3.9260475166471467`*^9}, {
   3.926047591489419*^9, 3.926047604592033*^9}, 3.9260477338080187`*^9, 
   3.9260477983804417`*^9, {3.9260478708639603`*^9, 3.926047981800996*^9}, 
   3.926048082325882*^9, 3.926048116387475*^9, 3.926133609196629*^9, {
   3.926133647349925*^9, 3.926133729297118*^9}, {3.9261339987441254`*^9, 
   3.926134024800729*^9}, {3.9261341239860716`*^9, 3.926134178207155*^9}, {
   3.926134209536233*^9, 3.926134234196685*^9}, {3.926134276618449*^9, 
   3.926134296583171*^9}, {3.926134328384896*^9, 3.926134396711558*^9}, {
   3.926134447072649*^9, 3.92613445512043*^9}, 3.926134504770557*^9, {
   3.92613454677303*^9, 3.926134564872676*^9}, 3.926134644408887*^9, {
   3.92613467451523*^9, 3.926134722817118*^9}, 3.9261427186812224`*^9, {
   3.926143785789668*^9, 3.926143824703295*^9}, {3.9261438634405136`*^9, 
   3.92614387549414*^9}, {3.9261439556527205`*^9, 3.926144020378787*^9}, {
   3.926144275120921*^9, 3.92614437726663*^9}, 3.9261444263664465`*^9, {
   3.926144486637223*^9, 3.926144544174923*^9}, 3.926144841385737*^9, 
   3.926145187610564*^9, {3.9270988219357643`*^9, 3.927098840166531*^9}, 
   3.927098886660016*^9, 3.92709975817117*^9, 3.9270998230224795`*^9, {
   3.927099892659016*^9, 3.927099930153096*^9}, {3.92709996565817*^9, 
   3.92709998747474*^9}, {3.927100182559022*^9, 3.927100191711195*^9}, {
   3.9271002271580086`*^9, 3.9271002387256184`*^9}, {3.927100306936891*^9, 
   3.92710031784838*^9}, {3.9271003516037254`*^9, 3.927100415714735*^9}, 
   3.927100464810094*^9, {3.927101297958349*^9, 3.9271013123995132`*^9}, 
   3.927101959537132*^9, {3.927102094564475*^9, 3.927102110840372*^9}, {
   3.927102246958084*^9, 3.927102281513492*^9}, 3.927104550636329*^9, 
   3.927124071070366*^9, {3.927124127709923*^9, 3.9271241581976576`*^9}, 
   3.927124287815303*^9, 3.927124320699244*^9, 3.927124651866125*^9, {
   3.927124729969536*^9, 3.927124751217626*^9}, {3.927124904776569*^9, 
   3.9271249150306444`*^9}, {3.927185254332079*^9, 3.927185305164613*^9}, 
   3.9409972946329308`*^9},
 CellLabel->"Out[8]=",ExpressionUUID->"b23e0575-a8ad-7949-af22-34a427fa8376"],

Cell[BoxData[
 RowBox[{"{", 
  TemplateBox[{
    RowBox[{"-", "y"}], 
    RowBox[{"y", ">", "0"}]},
   "ConditionalExpression"], "}"}]], "Output",
 CellChangeTimes->{
  3.926047152963863*^9, 3.9260472874319015`*^9, {3.926047351630525*^9, 
   3.926047377922821*^9}, {3.926047462786542*^9, 3.9260475166471467`*^9}, {
   3.926047591489419*^9, 3.926047604592033*^9}, 3.9260477338080187`*^9, 
   3.9260477983804417`*^9, {3.9260478708639603`*^9, 3.926047981800996*^9}, 
   3.926048082325882*^9, 3.926048116387475*^9, 3.926133609196629*^9, {
   3.926133647349925*^9, 3.926133729297118*^9}, {3.9261339987441254`*^9, 
   3.926134024800729*^9}, {3.9261341239860716`*^9, 3.926134178207155*^9}, {
   3.926134209536233*^9, 3.926134234196685*^9}, {3.926134276618449*^9, 
   3.926134296583171*^9}, {3.926134328384896*^9, 3.926134396711558*^9}, {
   3.926134447072649*^9, 3.92613445512043*^9}, 3.926134504770557*^9, {
   3.92613454677303*^9, 3.926134564872676*^9}, 3.926134644408887*^9, {
   3.92613467451523*^9, 3.926134722817118*^9}, 3.9261427186812224`*^9, {
   3.926143785789668*^9, 3.926143824703295*^9}, {3.9261438634405136`*^9, 
   3.92614387549414*^9}, {3.9261439556527205`*^9, 3.926144020378787*^9}, {
   3.926144275120921*^9, 3.92614437726663*^9}, 3.9261444263664465`*^9, {
   3.926144486637223*^9, 3.926144544174923*^9}, 3.926144841385737*^9, 
   3.926145187610564*^9, {3.9270988219357643`*^9, 3.927098840166531*^9}, 
   3.927098886660016*^9, 3.92709975817117*^9, 3.9270998230224795`*^9, {
   3.927099892659016*^9, 3.927099930153096*^9}, {3.92709996565817*^9, 
   3.92709998747474*^9}, {3.927100182559022*^9, 3.927100191711195*^9}, {
   3.9271002271580086`*^9, 3.9271002387256184`*^9}, {3.927100306936891*^9, 
   3.92710031784838*^9}, {3.9271003516037254`*^9, 3.927100415714735*^9}, 
   3.927100464810094*^9, {3.927101297958349*^9, 3.9271013123995132`*^9}, 
   3.927101959537132*^9, {3.927102094564475*^9, 3.927102110840372*^9}, {
   3.927102246958084*^9, 3.927102281513492*^9}, 3.927104550636329*^9, 
   3.927124071070366*^9, {3.927124127709923*^9, 3.9271241581976576`*^9}, 
   3.927124287815303*^9, 3.927124320699244*^9, 3.927124651866125*^9, {
   3.927124729969536*^9, 3.927124751217626*^9}, {3.927124904776569*^9, 
   3.9271249150306444`*^9}, {3.927185254332079*^9, 3.927185305164613*^9}, 
   3.9409972947118034`*^9},
 CellLabel->"Out[13]=",ExpressionUUID->"9f4aae58-bb27-f349-aef4-675f87edf0fd"],

Cell[BoxData[
 RowBox[{"{", 
  TemplateBox[{
    RowBox[{
      FractionBox["1", "2"], " ", "y", " ", 
      RowBox[{"(", 
        RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"Log", "[", 
            RowBox[{"2", " ", "y"}], "]"}]}], ")"}]}], 
    RowBox[{"y", ">", "0"}]},
   "ConditionalExpression"], "}"}]], "Output",
 CellChangeTimes->{
  3.926047152963863*^9, 3.9260472874319015`*^9, {3.926047351630525*^9, 
   3.926047377922821*^9}, {3.926047462786542*^9, 3.9260475166471467`*^9}, {
   3.926047591489419*^9, 3.926047604592033*^9}, 3.9260477338080187`*^9, 
   3.9260477983804417`*^9, {3.9260478708639603`*^9, 3.926047981800996*^9}, 
   3.926048082325882*^9, 3.926048116387475*^9, 3.926133609196629*^9, {
   3.926133647349925*^9, 3.926133729297118*^9}, {3.9261339987441254`*^9, 
   3.926134024800729*^9}, {3.9261341239860716`*^9, 3.926134178207155*^9}, {
   3.926134209536233*^9, 3.926134234196685*^9}, {3.926134276618449*^9, 
   3.926134296583171*^9}, {3.926134328384896*^9, 3.926134396711558*^9}, {
   3.926134447072649*^9, 3.92613445512043*^9}, 3.926134504770557*^9, {
   3.92613454677303*^9, 3.926134564872676*^9}, 3.926134644408887*^9, {
   3.92613467451523*^9, 3.926134722817118*^9}, 3.9261427186812224`*^9, {
   3.926143785789668*^9, 3.926143824703295*^9}, {3.9261438634405136`*^9, 
   3.92614387549414*^9}, {3.9261439556527205`*^9, 3.926144020378787*^9}, {
   3.926144275120921*^9, 3.92614437726663*^9}, 3.9261444263664465`*^9, {
   3.926144486637223*^9, 3.926144544174923*^9}, 3.926144841385737*^9, 
   3.926145187610564*^9, {3.9270988219357643`*^9, 3.927098840166531*^9}, 
   3.927098886660016*^9, 3.92709975817117*^9, 3.9270998230224795`*^9, {
   3.927099892659016*^9, 3.927099930153096*^9}, {3.92709996565817*^9, 
   3.92709998747474*^9}, {3.927100182559022*^9, 3.927100191711195*^9}, {
   3.9271002271580086`*^9, 3.9271002387256184`*^9}, {3.927100306936891*^9, 
   3.92710031784838*^9}, {3.9271003516037254`*^9, 3.927100415714735*^9}, 
   3.927100464810094*^9, {3.927101297958349*^9, 3.9271013123995132`*^9}, 
   3.927101959537132*^9, {3.927102094564475*^9, 3.927102110840372*^9}, {
   3.927102246958084*^9, 3.927102281513492*^9}, 3.927104550636329*^9, 
   3.927124071070366*^9, {3.927124127709923*^9, 3.9271241581976576`*^9}, 
   3.927124287815303*^9, 3.927124320699244*^9, 3.927124651866125*^9, {
   3.927124729969536*^9, 3.927124751217626*^9}, {3.927124904776569*^9, 
   3.9271249150306444`*^9}, {3.927185254332079*^9, 3.927185305164613*^9}, 
   3.94099729478994*^9},
 CellLabel->"Out[14]=",ExpressionUUID->"575a7999-7893-a442-be88-20a56af7c328"],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"2", " ", "x"}]], "2"]], "Output",
 CellChangeTimes->{
  3.926047152963863*^9, 3.9260472874319015`*^9, {3.926047351630525*^9, 
   3.926047377922821*^9}, {3.926047462786542*^9, 3.9260475166471467`*^9}, {
   3.926047591489419*^9, 3.926047604592033*^9}, 3.9260477338080187`*^9, 
   3.9260477983804417`*^9, {3.9260478708639603`*^9, 3.926047981800996*^9}, 
   3.926048082325882*^9, 3.926048116387475*^9, 3.926133609196629*^9, {
   3.926133647349925*^9, 3.926133729297118*^9}, {3.9261339987441254`*^9, 
   3.926134024800729*^9}, {3.9261341239860716`*^9, 3.926134178207155*^9}, {
   3.926134209536233*^9, 3.926134234196685*^9}, {3.926134276618449*^9, 
   3.926134296583171*^9}, {3.926134328384896*^9, 3.926134396711558*^9}, {
   3.926134447072649*^9, 3.92613445512043*^9}, 3.926134504770557*^9, {
   3.92613454677303*^9, 3.926134564872676*^9}, 3.926134644408887*^9, {
   3.92613467451523*^9, 3.926134722817118*^9}, 3.9261427186812224`*^9, {
   3.926143785789668*^9, 3.926143824703295*^9}, {3.9261438634405136`*^9, 
   3.92614387549414*^9}, {3.9261439556527205`*^9, 3.926144020378787*^9}, {
   3.926144275120921*^9, 3.92614437726663*^9}, 3.9261444263664465`*^9, {
   3.926144486637223*^9, 3.926144544174923*^9}, 3.926144841385737*^9, 
   3.926145187610564*^9, {3.9270988219357643`*^9, 3.927098840166531*^9}, 
   3.927098886660016*^9, 3.92709975817117*^9, 3.9270998230224795`*^9, {
   3.927099892659016*^9, 3.927099930153096*^9}, {3.92709996565817*^9, 
   3.92709998747474*^9}, {3.927100182559022*^9, 3.927100191711195*^9}, {
   3.9271002271580086`*^9, 3.9271002387256184`*^9}, {3.927100306936891*^9, 
   3.92710031784838*^9}, {3.9271003516037254`*^9, 3.927100415714735*^9}, 
   3.927100464810094*^9, {3.927101297958349*^9, 3.9271013123995132`*^9}, 
   3.927101959537132*^9, {3.927102094564475*^9, 3.927102110840372*^9}, {
   3.927102246958084*^9, 3.927102281513492*^9}, 3.927104550636329*^9, 
   3.927124071070366*^9, {3.927124127709923*^9, 3.9271241581976576`*^9}, 
   3.927124287815303*^9, 3.927124320699244*^9, 3.927124651866125*^9, {
   3.927124729969536*^9, 3.927124751217626*^9}, {3.927124904776569*^9, 
   3.9271249150306444`*^9}, {3.927185254332079*^9, 3.927185305164613*^9}, 
   3.94099729478994*^9},
 CellLabel->"Out[15]=",ExpressionUUID->"0f2679d7-31ec-9e4a-82df-5daf0b01a7d0"],

Cell[BoxData[
 RowBox[{"{", 
  TemplateBox[{
    RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"Log", "[", 
        RowBox[{"2", " ", "y"}], "]"}]}], 
    RowBox[{"y", ">", "0"}]},
   "ConditionalExpression"], "}"}]], "Output",
 CellChangeTimes->{
  3.926047152963863*^9, 3.9260472874319015`*^9, {3.926047351630525*^9, 
   3.926047377922821*^9}, {3.926047462786542*^9, 3.9260475166471467`*^9}, {
   3.926047591489419*^9, 3.926047604592033*^9}, 3.9260477338080187`*^9, 
   3.9260477983804417`*^9, {3.9260478708639603`*^9, 3.926047981800996*^9}, 
   3.926048082325882*^9, 3.926048116387475*^9, 3.926133609196629*^9, {
   3.926133647349925*^9, 3.926133729297118*^9}, {3.9261339987441254`*^9, 
   3.926134024800729*^9}, {3.9261341239860716`*^9, 3.926134178207155*^9}, {
   3.926134209536233*^9, 3.926134234196685*^9}, {3.926134276618449*^9, 
   3.926134296583171*^9}, {3.926134328384896*^9, 3.926134396711558*^9}, {
   3.926134447072649*^9, 3.92613445512043*^9}, 3.926134504770557*^9, {
   3.92613454677303*^9, 3.926134564872676*^9}, 3.926134644408887*^9, {
   3.92613467451523*^9, 3.926134722817118*^9}, 3.9261427186812224`*^9, {
   3.926143785789668*^9, 3.926143824703295*^9}, {3.9261438634405136`*^9, 
   3.92614387549414*^9}, {3.9261439556527205`*^9, 3.926144020378787*^9}, {
   3.926144275120921*^9, 3.92614437726663*^9}, 3.9261444263664465`*^9, {
   3.926144486637223*^9, 3.926144544174923*^9}, 3.926144841385737*^9, 
   3.926145187610564*^9, {3.9270988219357643`*^9, 3.927098840166531*^9}, 
   3.927098886660016*^9, 3.92709975817117*^9, 3.9270998230224795`*^9, {
   3.927099892659016*^9, 3.927099930153096*^9}, {3.92709996565817*^9, 
   3.92709998747474*^9}, {3.927100182559022*^9, 3.927100191711195*^9}, {
   3.9271002271580086`*^9, 3.9271002387256184`*^9}, {3.927100306936891*^9, 
   3.92710031784838*^9}, {3.9271003516037254`*^9, 3.927100415714735*^9}, 
   3.927100464810094*^9, {3.927101297958349*^9, 3.9271013123995132`*^9}, 
   3.927101959537132*^9, {3.927102094564475*^9, 3.927102110840372*^9}, {
   3.927102246958084*^9, 3.927102281513492*^9}, 3.927104550636329*^9, 
   3.927124071070366*^9, {3.927124127709923*^9, 3.9271241581976576`*^9}, 
   3.927124287815303*^9, 3.927124320699244*^9, 3.927124651866125*^9, {
   3.927124729969536*^9, 3.927124751217626*^9}, {3.927124904776569*^9, 
   3.9271249150306444`*^9}, {3.927185254332079*^9, 3.927185305164613*^9}, 
   3.940997294806072*^9},
 CellLabel->"Out[16]=",ExpressionUUID->"f201afbf-b6e3-2f4c-90cf-1ffce5b6fb3c"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.92710038482003*^9, 
  3.927100386711008*^9}},ExpressionUUID->"930af652-8d06-4545-94bc-\
2f49be526d5d"]
},
WindowSize->{576, 521},
WindowMargins->{{161, Automatic}, {Automatic, 0}},
FrontEndVersion->"14.0 for Microsoft Windows (64-bit) (December 12, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"33eac669-1048-1343-b77e-35c3f43ccdff"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 5589, 125, 371, "Input",ExpressionUUID->"2091e894-d3b4-4fde-843f-b5cb93fbd1bb"],
Cell[6172, 149, 2358, 35, 50, "Output",ExpressionUUID->"5e24059d-b902-5547-8537-62e8e2cef185"],
Cell[8533, 186, 2485, 40, 58, "Output",ExpressionUUID->"ed1e03cc-178b-6540-a91f-f574cec94442"],
Cell[11021, 228, 2683, 46, 68, "Output",ExpressionUUID->"b23e0575-a8ad-7949-af22-34a427fa8376"],
Cell[13707, 276, 2395, 37, 44, "Output",ExpressionUUID->"9f4aae58-bb27-f349-aef4-675f87edf0fd"],
Cell[16105, 315, 2585, 43, 58, "Output",ExpressionUUID->"575a7999-7893-a442-be88-20a56af7c328"],
Cell[18693, 360, 2356, 35, 50, "Output",ExpressionUUID->"0f2679d7-31ec-9e4a-82df-5daf0b01a7d0"],
Cell[21052, 397, 2486, 40, 58, "Output",ExpressionUUID->"f201afbf-b6e3-2f4c-90cf-1ffce5b6fb3c"]
}, Open  ]],
Cell[23553, 440, 151, 3, 28, "Input",ExpressionUUID->"930af652-8d06-4545-94bc-2f49be526d5d"]
}
]
*)

