import numpy as np


def RSE(pred, true):
    return np.sqrt(np.sum((true - pred) ** 2)) / np.sqrt(np.sum((true - true.mean()) ** 2))


def CORR(pred, true):
    u = ((true - true.mean(0)) * (pred - pred.mean(0))).sum(0)
    d = np.sqrt(((true - true.mean(0)) ** 2 * (pred - pred.mean(0)) ** 2).sum(0))
    return (u / d).mean(-1)


def MAE(pred, true):
    return np.mean(np.abs(pred - true))


def MSE(pred, true):
    return np.mean((pred - true) ** 2)


def RMSE(pred, true):
    return np.sqrt(MSE(pred, true))


def MAPE(pred, true):
    return np.mean(np.abs((pred - true) / true))


def MSPE(pred, true):
    return np.mean(np.square((pred - true) / true))


def metric(pred, true):
    mae = MAE(pred, true)
    mse = MSE(pred, true)
    rmse = RMSE(pred, true)
    mape = MAPE(pred, true)
    mspe = MSPE(pred, true)

    return mae, mse, rmse, mape, mspe



gt = np.load('/home/ironllen/Documents/iTransformer/compare_result/ETTh1_testall/ETTh1_96_96_Flowformer_ETTh1_M_ft96_sl48_ll96_pl256_dm8_nh2_el1_dl256_df1_fctimeF_ebTrue_dtreal_projection_0/true.npy')
flowformer = np.load('/home/ironllen/Documents/iTransformer/compare_result/ETTh1_testall/ETTh1_96_96_Flowformer_ETTh1_M_ft96_sl48_ll96_pl256_dm8_nh2_el1_dl256_df1_fctimeF_ebTrue_dtreal_projection_0/pred.npy')
itrans = np.load('/home/ironllen/Documents/iTransformer/compare_result/ETTh1_testall/ETTh1_96_96_iTransformer_ETTh1_M_ft96_sl48_ll96_pl256_dm8_nh2_el1_dl256_df1_fctimeF_ebTrue_dtreal_projection_0/pred.npy')
informer = np.load('/home/ironllen/Documents/iTransformer/compare_result/ETTh1_testall/ETTh1_96_96_Informer_ETTh1_M_ft96_sl48_ll96_pl256_dm8_nh2_el1_dl256_df1_fctimeF_ebTrue_dtreal_projection_0/pred.npy')
trans = np.load('/home/ironllen/Documents/iTransformer/compare_result/ETTh1_testall/ETTh1_96_96_Transformer_ETTh1_M_ft96_sl48_ll96_pl256_dm8_nh2_el1_dl256_df1_fctimeF_ebTrue_dtreal_projection_0/pred.npy')


mse_itrans = np.zeros((gt.shape[0], 1))
for i in range(gt.shape[0]):
    mse = np.mean((gt[i] - itrans[i]) ** 2)
    mse_itrans[i] = mse

# mse_itrans_avg = np.average(mse_itrans, axis=0, keepdims=True)
# print(mse_itrans_avg)
mse_flowformer = np.zeros((gt.shape[0], 1))
for i in range(gt.shape[0]):
    mse = np.mean((gt[i] - flowformer[i]) ** 2)
    mse_flowformer[i] = mse

mse_trans = np.zeros((gt.shape[0], 1))
for i in range(gt.shape[0]):
    mse = np.mean((gt[i] - trans[i]) ** 2)
    mse_trans[i] = mse

mse_informer = np.zeros((gt.shape[0], 1))
for i in range(gt.shape[0]):
    mse = np.mean((gt[i] - informer[i]) ** 2)
    mse_informer[i] = mse

# print(mse_itrans[:10])
# print(mse_trans[:10])
# print(mse_informer[:10])
# print(mse_flowformer[:10])

mse_averages = np.zeros((gt.shape[0], 1))

# 计算MSE
for i in range(gt.shape[0]):
    mse_ab = np.mean((itrans[i] - flowformer[i]) ** 2)
    mse_ac = np.mean((itrans[i] - informer[i]) ** 2)
    mse_ad = np.mean((itrans[i] - trans[i]) ** 2)
    mse_bc = np.mean((flowformer[i] - informer[i]) ** 2)
    mse_bd = np.mean((flowformer[i] - trans[i]) ** 2)
    mse_cd = np.mean((informer[i] - trans[i]) ** 2)

    # 计算MSE的平均值
    mse_average = (mse_ab + mse_ac + mse_ad + mse_bc + mse_bd + mse_cd) / 6
    mse_averages[i] = mse_average

mse_2gt = (mse_itrans + mse_flowformer + mse_informer + mse_trans)/4
# print(mse_2gt[:10])

# 将四个数组在第二维度（dim=1）上堆叠成一个新数组
stacked_array = np.hstack((mse_flowformer, mse_trans, mse_itrans, mse_informer))

min_4model = np.min(stacked_array, axis=1, keepdims=True)
# 计算标准差，axis=1 指在每一行内计算标准差
std_4model = np.std(stacked_array, axis=1, keepdims=True)

def generate_new_array(arr):
    n = arr.shape[0]
    new_arr = np.zeros_like(arr)  # 创建全零数组，与原数组形状相同

    threshold = np.percentile(arr, 30)  # 计算前30%的阈值

    for i in range(n):
        if arr[i] <= threshold:
            new_arr[i:i+96] += 1  # 将当前索引及后96位索引的值加1

    return new_arr

aug_index = generate_new_array(std_4model)
# print(aug_index.shape)
# print(aug_index[:10])

import pandas as pd

# Load the CSV file
file_path = '/home/ironllen/Documents/iTransformer/dataset/ETT-small/ETTh1_real.csv'
data = pd.read_csv(file_path, index_col=0)

# Compute the noise standard deviation from the index array
noise_stds = aug_index * 0.05
# print(noise_stds.shape)
# Generate random noise for each row using the calculated standard deviations
noisy_data = data.iloc[:aug_index.shape[0]].copy()
for i in range(len(noisy_data)):
    row_noise = np.random.normal(loc=1, scale=noise_stds[i], size=len(data.columns))
    noisy_data.iloc[i] = noisy_data.iloc[i] * row_noise

# Concatenate the noisy part with the remaining part of the data that remains unchanged
result = pd.concat([noisy_data, data.iloc[aug_index.shape[0]:]])


# Save the modified dataset to a new CSV file
output_file_path = '/home/ironllen/Documents/iTransformer/dataset/ETT-small/ETTh1_varaug_0.05.csv'
result.to_csv(output_file_path)

output_file_path