# GGPL: GBDT-Guided Piecewise-Linear Embedding

This repository contains the code for the paper **"Enhancing Deep Tabular Models with GBDT-Guided Piecewise-Linear Embeddings"**.

## Environment

- OS: Ubuntu 20.04  
- CUDA: 11.8  
- Install dependencies:
  ```bash
  conda env create -n ggpl --file environment.yaml
  ```

## Datasets

Download datasets by following the instructions in  
[https://github.com/yandex-research/tabm/tree/main/paper#data](https://github.com/yandex-research/tabm/tree/main/paper#data)

## Run Experiments

Set environment variables:
```bash
export gpu_ids=0
export model_name=mlp-ggpl
export dataset_name=adult
```

Run an experiment:
```bash
CUDA_VISIBLE_DEVICES=${gpu_ids} python bin/go.py exp/${model_name}/${dataset_name}/0-tuning.toml
```

Run TabPFN:
```bash
CUDA_VISIBLE_DEVICES=${gpu_ids} python bin/run_tabpfn.py exp/tabpfn/${dataset_name}/0-tuning.toml
```

## Notes

- `modernNCA` and `t2gformer` are modified from [TALENT](https://github.com/LAMDA-Tabular/TALENT)
- This codebase is based on [TABM](https://github.com/yandex-research/tabm).
