# Implementation for Neural Flow on Surfaces
Our codes have not been organized and this is just draft version. We will fix it in the final revised version.

# Requirements:
jax,flax,trimesh,ployscope,libigl,optax,healpy

# Parparation and running command:

## sphere rot
```
python ./sphere_rot/jax_sphere_3d.py
```
## sphere jet
```
python ./sphere_jet/jax_sphere_3d.py
```
## Inclined plane flow
```
python ./planar_flow/jax_sphere_3d.py
```
## Explicit mesh flow
Prepare the explicit mesh data (.obj,.mesh) on the ./mesh_process.
```
python ./planar_flow/jax_sphere_3d.py
```
## Implicit mesh flow
Prepare the explicit mesh data (.ply) on the ./mesh_process.
Use
```
python ./imp_flow/mesh_process/sdf_implict.py
```
to sample uniform points on meshes, then
use 
```
python ./imp_flow/mesh_process/fit_mlps.py
```
to fit implicit neural representation for SDF of meshes.
Use
```
python ./imp_flow/mesh_process/geo_vis.py
```
to prepare sample inputs for main process together with the SDF implicit neural representation checkpoint.
Then use
```
python ./planar_flow/jax_sphere_3d.py
```
## Flow with conditioning
Prepare EMNIST dataset on ./alphabet_flow.
```
python ./planar_flow/jax_sphere_3d_auto.py
```
##  Flow for Helmholtz decomposition
Prepare .grib dataset from copernicus climate data storage, then run
```
python ./planar_flow/jax_sphere_3d.py
```


# Reference and data source
[1] https://github.com/facebookresearch/neural-conservation-law/tree/main

[2] https://github.com/libigl/libigl-tutorial-data

[3] https://www.cs.cmu.edu/~kmcrane/Projects/ModelRepository/

[4] https://graphics.stanford.edu/data/3Dscanrep/

[5] https://www.nist.gov/itl/products-and-services/emnist-dataset

[6] https://cds.climate.copernicus.eu/#!/home