import jax.numpy as jnp


def sh4_table(x,y,z,r):
    r = jnp.sqrt(x**2+y**2+z**2)
    
    Y40 = 0.75*jnp.sqrt(35)*x*y*(x**2 - y**2)/(jnp.sqrt(jnp.pi)*r**4)
    Y41 = 0.0625*jnp.sqrt(70)*y*z*(18.0*x**2 - 6.0*y**2)/(jnp.sqrt(jnp.pi)*r**4)
    Y42 = 0.0625*jnp.sqrt(5)*x*y*(72.0*r**2 - 84.0*x**2 - 84.0*y**2)/(jnp.sqrt(jnp.pi)*r**4)
    Y43 = 1.0*jnp.sqrt(10)*y*z*(1.5*r**2 - 2.625*x**2 - 2.625*y**2)/(jnp.sqrt(jnp.pi)*r**4)
    Y44 = 3*(8*r**4 - 40*r**2*x**2 - 40*r**2*y**2 + 35*x**4 + 70*x**2*y**2 + 35*y**4)/(16*jnp.sqrt(jnp.pi)*r**4)
    Y45 = 3*jnp.sqrt(10)*x*z*(4*r**2 - 7*x**2 - 7*y**2)/(8*jnp.sqrt(jnp.pi)*r**4)
    Y46 = -3*jnp.sqrt(5)*(x - y)*(x + y)*(-6*r**2 + 7*x**2 + 7*y**2)/(8*jnp.sqrt(jnp.pi)*r**4)
    Y47 = 3*jnp.sqrt(70)*x*z*(x**2 - 3*y**2)/(8*jnp.sqrt(jnp.pi)*r**4)
    Y48 = 3*jnp.sqrt(35)*(x**4 - 6*x**2*y**2 + y**4)/(16*jnp.sqrt(jnp.pi)*r**4)
    return jnp.array([Y40,Y41,Y42,Y43,Y44,Y45,Y46,Y47,Y48])

def sh3_table(x,y,z,r):
    r = jnp.jnp.sqrt(x**2+y**2+z**2)
    
    Y30 = 0.0625*jnp.sqrt(70)*y*(6.0*x**2 - 2.0*y**2)/(jnp.sqrt(jnp.pi)*r**3)
    Y31 = 0.5*jnp.sqrt(105)*x*y*z/(jnp.sqrt(jnp.pi)*r**3)
    Y32 = 1.0*jnp.sqrt(42)*y*(0.5*r**2 - 0.625*x**2 - 0.625*y**2)/(jnp.sqrt(jnp.pi)*r**3)
    Y33 = jnp.sqrt(7)*z*(2*r**2 - 5*x**2 - 5*y**2)/(4*jnp.sqrt(jnp.pi)*r**3)
    Y34 = jnp.sqrt(42)*x*(4*r**2 - 5*x**2 - 5*y**2)/(8*jnp.sqrt(jnp.pi)*r**3)
    Y35 = jnp.sqrt(105)*z*(x - y)*(x + y)/(4*jnp.sqrt(jnp.pi)*r**3)
    Y36 = jnp.sqrt(70)*x*(x**2 - 3*y**2)/(8*jnp.sqrt(jnp.pi)*r**3)
    return jnp.array([Y30,Y31,Y32,Y33,Y34,Y35,Y36])