import numpy as np

import pygrib


f = './adaptor.mars.internal-1706273727.9415257-20843-9-ca8eb50f-b8a4-457a-b6b5-28bac50d1749.grib'
grbs = pygrib.open(f)
grbs.seek(0)

for grb in grbs:
    print(grb)

grb_u = grbs.select(name='100 metre U wind component')[4]
grb_v = grbs.select(name='100 metre V wind component')[4]


grb_u_ = grb_u.values 
lats, lons = grb_u.latlons()
print(lats)
grb_v_ = grb_v.values 
lats, lons = grb_u.latlons()
print(lats)

x = np.cos(lats/180*np.pi) * np.cos(lons/180*np.pi)
y = np.cos(lats/180*np.pi) * np.sin(lons/180*np.pi)
z = np.sin(lats/180*np.pi)

print(lats.shape)
pts = np.stack([x,y,z],axis=-1)#.reshape(-1,3)
uv = np.stack([grb_u_,grb_v_],axis=-1)#.reshape(-1,2)
uv_k = np.sqrt(uv[:,:,0]**2 + uv[:,:,1]**2)


# import polyscope as ps 
# ps.init()
# ps_cloud = ps.register_point_cloud("my points", pts)
# ps_cloud.add_vector_quantity("rand vecs", uv, radius=0.001, length=0.005, color=(0.2, 0.5, 0.5))
# ps.show()



import matplotlib.pyplot as plt
plt.imshow(uv_k, cmap='viridis')  # cmap是颜色映射，你可以根据需要选择
plt.colorbar()  # 显示颜色条

# 添加标题和标签（可选）
plt.title('Array Visualization')
plt.xlabel('X Axis')
plt.ylabel('Y Axis')

# 显示图像
plt.show()
